package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.sorttrack;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.Bbox;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.DetectionResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.NativeInference;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class KalmanSortTracker extends NativeInference {
    static final String     LOGTAG = KalmanSortTracker.class.getSimpleName();
    public float            SORT_PADDING_SCALE = 0f;//0.3f;//0.2f;//0.15f;
    public static final int SORT_TRACK_TIMEOUT = 20;//1s~10 frame

    private long            mNativePointer;
    private AtomicBoolean   mIsInited;

    public native long                      initNative();
    public native TrackBox.NativeTrackBox[] nativeTrackSort(float[][] bboxesObjArr, boolean isInited, boolean isPredict, long cppSortTrackerPtr);
    public native void                      releaseNative(long cppSortTrackerPtr);

    public KalmanSortTracker() {
        mNativePointer = initNative();
        mIsInited = new AtomicBoolean(false);
    }

    public KalmanSortTracker(float paddingScale) {
        mNativePointer = initNative();
        mIsInited = new AtomicBoolean(false);
        this.SORT_PADDING_SCALE = paddingScale;
    }

    @Nullable
    private TrackBox.NativeTrackBox[] doSortTrack(@NonNull List<Bbox> bboxes){
        if(bboxes.size() > 0) {
            mIsInited.set(true);

            float[][] bboxesObjArr = new float[bboxes.size()][4];

            for (int i = 0; i < bboxes.size(); i++) {
                Bbox box = bboxes.get(i);
                //addPaddingScale(box);//for better tracking
                //add padding for better tracking
                float width = box.x2 - box.x1;
                float height = box.y2 - box.y1;
                //
                int paddingWidth = (int)(width * SORT_PADDING_SCALE);
                int paddingHeight = (int)(height * SORT_PADDING_SCALE);
                //
                bboxesObjArr[i] = new float[]{box.x1 - paddingWidth, box.y1 - paddingHeight, box.x2 + paddingWidth, box.y2 + paddingHeight};
            }

            TrackBox.NativeTrackBox[] trResults = nativeTrackSort(bboxesObjArr, mIsInited.get(), false, mNativePointer);

//            for (TrackUtils.TrackResult tmp : trResults){
//                Log.d(LOGTAG + "_checkResultTrackNative", "native track info: frame=" + tmp.frame +
//                        " id=" + tmp.id +
//                        " boxId=" + tmp.boxId +
//                        " uphit=" + tmp.update_hits +
//                        " prehit="+ tmp.predict_hits +
//                        " box={" + tmp.x1 + "," + tmp.y1 + "," + tmp.width + "," + tmp.height + "}"
//                );
//            }
            //Log.d(LOGTAG, "prepareTrackSort " + trResults.length + " boxes " + bboxes.size());
            return trResults;
        } else {
            if(mIsInited.get()) nativeTrackSort(null, mIsInited.get(), true, mNativePointer);
            return null;
        }
    }

    @Override
    public TrackResult runInference(@NonNull InferenceResult inputInference) {
        DetectionResult detectionResult = (DetectionResult) inputInference;
        List<Bbox> bBoxDetected = detectionResult.getBboxList();

        //TODO: warp nativeBox & combine box to TrackBox -> wrap list track box to TrackResult and return
        TrackBox.NativeTrackBox[] listNativeTrackBox = doSortTrack(bBoxDetected);
        if (listNativeTrackBox != null) {
            List<TrackBox> listTrackBox = new ArrayList<>();
            for (TrackBox.NativeTrackBox nativeTrackBox : listNativeTrackBox){
                //boxId = -1 mean an exist track un-match with any box
                if (nativeTrackBox.boxId > -1) {
                    TrackBox trackBox = new TrackBox(inputInference, nativeTrackBox);
                    trackBox.addResult(bBoxDetected.get(nativeTrackBox.boxId));
                    listTrackBox.add(trackBox);
                }
            }
            return new TrackResult(inputInference, listTrackBox);
        } else {
            return null;
        }
    }

    @Override
    public void release() {
        releaseNative(mNativePointer);
    }

}
