package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.align;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;

import org.opencv.core.Mat;

public class FaceAlignResult extends InferenceResult {
    private Mat alignedFaceMat;
    /**
     * Constructor
     * @param previousInference
     * @param alignedFaceMat
     */
    public FaceAlignResult(InferenceResult previousInference, Mat alignedFaceMat) {
        super(previousInference);
        this.alignedFaceMat = alignedFaceMat;
    }

    public Mat getAlignedFaceMat() {
        return alignedFaceMat;
    }

    public void setAlignedFaceMat(Mat alignedFaceMat) {
        this.alignedFaceMat = alignedFaceMat;
    }

    @Override
    public ResultName getResultName() {
        return ResultName.faceAlign;
    }

    @Override
    public void summarizeInferenceDataInfo() {
        super.summarizeInferenceDataInfo();
        this.alignedFaceMat = null;
    }
}
