package com.securityandsafetythings.examples.aiapp.aicore.aiprocess;

import android.app.Application;
import android.content.Context;

import androidx.annotation.NonNull;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.motion.MotionDetector;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.motion.MotionResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.sorttrack.TrackResult;

public class AIHumanMotionProcessor extends AIHumanProcessor {
    static final String LOGTAG = AIHumanMotionProcessor.class.getSimpleName();
    public long lastMotionTime = 0;
    private static final long DELAY_MOTION_ACTIVE = 5000;
    //Algorithm object
    private MotionDetector motionDetector;

    public AIHumanMotionProcessor(Context context, Application application, AIProcess nextProcess) {
        super(context, application, nextProcess);
        this.motionDetector = new MotionDetector(false);
        this.setName("HumanMotion");
    }

    @Override
    public TrackResult onProcess(@NonNull InferenceResult inputInference) {
        //long startMotion = System.currentTimeMillis();
        MotionResult motionResult = motionDetector.runInference(inputInference);
        //long motionTime = System.currentTimeMillis() - startMotion;
        //Log.d(LOGTAG +"_checkRuntime", "motion runtime = " +motionTime +"ms");

        boolean isHaveMotion = motionResult.isMotion();
        //Log.d("MediaPool_", "check motion = "+ isHaveMotion  );
        if (isHaveMotion){
            lastMotionTime = System.currentTimeMillis();
            return super.onProcess(motionResult);
        } else if (System.currentTimeMillis() - lastMotionTime < DELAY_MOTION_ACTIVE){
            return super.onProcess(motionResult);
        }
        return null;
    }

    @Override
    public void onProcessEnd() {
        super.onProcessEnd();
        motionDetector.release();
    }
}
