package com.securityandsafetythings.examples.aiapp.aicore.aiprocess;

import android.app.Application;
import android.content.Context;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.motion.MotionDetector;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.motion.MotionResult;

public class AIMotionProcessor extends AIProcess{
    static final String LOGTAG = AIMotionProcessor.class.getSimpleName();

    private MotionDetector motionDetector;
    private static final long DELAY_MOTION_ACTIVE = 5000;
    public long lastMotionTime = 0;

    public AIMotionProcessor(Context mContext, Application mApplication, AIProcess nextProcess) {
        super(mContext, mApplication, nextProcess);
        this.motionDetector = new MotionDetector(false);
        this.setName("Mt" + System.currentTimeMillis());
    }

    @Override
    public InferenceResult onProcess(InferenceResult inputInference) {
        MotionResult motionResult = motionDetector.runInference(inputInference);
        boolean isHaveMotion = motionResult.isMotion();

        if (isHaveMotion){
            lastMotionTime = System.currentTimeMillis();
            return motionResult;
        } else if (System.currentTimeMillis() - lastMotionTime < DELAY_MOTION_ACTIVE){
            return motionResult;
        }
        return null;
    }

    @Override
    public void onProcessEnd() {
        motionDetector.release();
    }
}
