package com.securityandsafetythings.examples.aiapp.aicore.mediapool;

import android.graphics.Bitmap;

public class MediaNode {
    private Bitmap bitmap;
    //private Audio ???
    private Integer reference = 0;
    long frameId;
    public MediaNode forwardPtr = null;
    public MediaNode backwardPtr = null;

    public MediaNode(Bitmap bitmap) {
        this.bitmap = bitmap;
        this.frameId = System.currentTimeMillis();
    }

    /** !!! Must be called when this Node not used anymore !!! */
    public void free(){
        synchronized (reference) {
            this.reference--;
            //Log.d("MediaPool_", "check free mediaNode, bitmap = " + bitmap.hashCode() + " num refer = " + reference);
        }
    }

    public Bitmap getBitmap() {
        return bitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public boolean isReference(){
        synchronized (reference) {
            return reference > 0;
        }
    }

    public int getReference() {
        synchronized (reference){
            return reference;
        }
    }

    public void takeReference() {
        synchronized (reference) {
            reference++;
        }
    }

    public long getFrameId() {
        return frameId;
    }

    public void setFrameId(long frameId) {
        this.frameId = frameId;
    }

    public MediaNode getForwardPtr() {
        return forwardPtr;
    }

    public void setForwardPtr(MediaNode forwardPtr) {
        this.forwardPtr = forwardPtr;
    }

    public MediaNode getBackwardPtr() {
        return backwardPtr;
    }

    public void setBackwardPtr(MediaNode backwardPtr) {
        this.backwardPtr = backwardPtr;
    }

}
