package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.classifier;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;

public class TFClassifyResult extends InferenceResult {
    private float[] rawOuputArray;
    private double tfFaceProb;
    private double finalProb;
    /**
     * Constructor
     * @param previousInference
     * @param tfFaceProb
     * @param rawOuputArray
     */
    public TFClassifyResult(InferenceResult previousInference, double tfFaceProb, float[] rawOuputArray, double finalProb) {
        super(previousInference);
        this.tfFaceProb = tfFaceProb;
        this.rawOuputArray = rawOuputArray;
        this.finalProb = finalProb;
    }

    public float[] getRawOuputArray() {
        return rawOuputArray;
    }

    public void setRawOuputArray(float[] rawOuputArray) {
        this.rawOuputArray = rawOuputArray;
    }

    public double getTfFaceProb() {
        return tfFaceProb;
    }

    public void setTfFaceProb(float tfFaceProb) {
        this.tfFaceProb = tfFaceProb;
    }

    public double getFinalProb() {
        return finalProb;
    }

    @Override
    public ResultName getResultName() {
        return ResultName.trueFace;
    }

    @Override
    public void summarizeInferenceDataInfo() {
        super.summarizeInferenceDataInfo();
        this.rawOuputArray = null;
    }
}
