package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;

import androidx.annotation.NonNull;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;

import org.opencv.core.Point;

public class Bbox extends InferenceResult implements Comparable<Bbox> {
    static final String LOGTAG = Bbox.class.getSimpleName();
    public String label;
    public float x1;
    public float y1;
    public float x2;
    public float y2;
    public Float conf;
    public Point landmarks[];// = new PointF[5];

    /** this box's constructor use as result of person detection */
    public Bbox(InferenceResult previousInference, float x1, float y1, float x2, float y2, Float conf){
        super(previousInference);
        Bitmap processBitmap = processMedia.getBitmap();
        this.x1 = clamp(x1, processBitmap.getWidth());
        this.y1 = clamp(y1, processBitmap.getHeight());
        this.x2 = clamp(x2, processBitmap.getWidth());
        this.y2 = clamp(y2, processBitmap.getHeight());
        this.conf = conf;
        //Log.d(LOGTAG, "check box create = (" + this.x1 + "," + this.y1 +") (" + this.x2 + "," + this.y2 + ")" );
    }

    /** this box's constructor use as result of vehicle detection */
    public Bbox(InferenceResult previousInference, float x1, float y1, float x2, float y2, Float conf, String label){
        super(previousInference);
        Bitmap processBitmap = processMedia.getBitmap();
        this.x1 = clamp(x1, processBitmap.getWidth());
        this.y1 = clamp(y1, processBitmap.getHeight());
        this.x2 = clamp(x2, processBitmap.getWidth());
        this.y2 = clamp(y2, processBitmap.getHeight());
        this.conf = conf;
        this.label = label;
        //Log.d(LOGTAG, "check box create = (" + this.x1 + "," + this.y1 +") (" + this.x2 + "," + this.y2 + ")" );
    }

    /** this box's constructor use as result of face detection */
    public Bbox(InferenceResult previousInference, float x1, float y1, float x2, float y2, Float conf, Point[] landmarks) {
        super(previousInference);
        Bitmap processBitmap = processMedia.getBitmap();
        this.x1 = clamp(x1, processBitmap.getWidth());
        this.y1 = clamp(y1, processBitmap.getHeight());
        this.x2 = clamp(x2, processBitmap.getWidth());
        this.y2 = clamp(y2, processBitmap.getHeight());
        this.conf = conf;
        this.landmarks  = landmarks;

    }

    // duplicates into another box
    public void copyTo(Bbox b){
        b.x1 = this.x1;
        b.y1 = this.y1;
        b.x2 = this.x2;
        b.y2 = this.y2;
        b.conf = this.conf;
        b.landmarks = this.landmarks;
    }

    public float clamp(float inputValue, float clampValue) {
        if (inputValue < 0){
            return 0;
        } else if (inputValue >= clampValue){
            return (clampValue - 1);
        }
        return inputValue;
    }

    public float[] getLandmarkAsArr(){
        float[] landmarkArr = new float[landmarks.length*2];
        int i =0;
        for (Point p : landmarks){
            landmarkArr[i++] = (float) p.x;
            landmarkArr[i++] = (float) p.y;
        }
        return landmarkArr;
    }

    public float getSize(){
        return (x2-x1)*(y2-y1);
    }

    @Override
    public int compareTo(@NonNull Bbox o) {
        return o.conf.compareTo(this.conf);
    }

    public Float getConfidence() {
        return conf;
    }

    public RectF getLocation() {
        return new RectF(x1, y1, x2, y2);
    }

    @Override
    public ResultName getResultName() {
        return ResultName.box;
    }

    @Override
    public String toString() {
        String string = "conf = " + conf +"\n";

        return string;
    }
}