package com.securityandsafetythings.examples.aiapp.aicore.aiprocess;

import static com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult.ResultName.box;
import static com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.human.ScrfdPersonDetector.IOU_THRESHOLD;
import static com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.human.ScrfdPersonDetector.TRUST_THRESHOLD;

import android.app.Application;
import android.content.Context;
import android.graphics.Canvas;

import androidx.annotation.NonNull;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.Bbox;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.human.HDResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.human.ScrfdPersonDetector;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.motion.MotionDetector;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.motion.MotionResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.sorttrack.KalmanSortTracker;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.sorttrack.TrackBox;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.sorttrack.TrackResult;

import org.opencv.core.Mat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AIHumanProcessor extends AIProcess{
    static final String LOGTAG = AIHumanProcessor.class.getSimpleName();

    /** Algorithm object */
    private ScrfdPersonDetector humanDetector;
    private KalmanSortTracker sortTracker;
    private ConcurrentMap<Integer, TrackBox> mapTrackTmp;

    /** Constant variable */
    public static final long TRACK_TIMEOUT = 10000; //10s


    public AIHumanProcessor(Context context, Application application, AIProcess nextProcess) {
        super(context, application, nextProcess);
        /*this.humanDetector = new ScrfdPersonDetector(
                this.mContext,
                this.mApplication,
                R.raw.scrfd_crowdhuman_500m_fe_aug_shape384x640_quantized,
                NeuralNetwork.Runtime.DSP
        );*/
        this.sortTracker = new KalmanSortTracker();
        mapTrackTmp = new ConcurrentHashMap<>();
        this.setName("HumanThread");
    }

    @Override
    public TrackResult onProcess(@NonNull InferenceResult inputInference) {
        Mat fgMat;
        boolean vibeMode;
        MotionResult motionResult = (MotionResult) inputInference;
        fgMat = motionResult.getForegroundMat();
        vibeMode = motionResult.getRuntimeMode();

        //if motion results null -> return null

        /*if (inputInference.hasResult(motionDetect)){
            motionResult = (MotionResult) inputInference.getInferenceResult(motionDetect);
            fgMat = motionResult.getForegroundMat();
            vibeMode = motionResult.getRuntimeMode();
        } else {
            Log.e("ai-process " + LOGTAG, "Error: onPrcess: inputInference cant cast to motionDetect result");
            return null;
        }*/

        /* STEP1: execute model */
        HDResult hdResult = humanDetector.runInference(inputInference);

        //TODO: render raw human detect results
        ///...
        //AiBasedDetection.RenderUIHumanSortInfo myParam1 = new AiBasedDetection.RenderUIHumanSortInfo(imageBmp, humanBoxes, null, null, 0, sourceId);//humanRenderObs

        /* STEP2: do sort track */
        //long startTrack = System.currentTimeMillis();
        TrackResult trackResult = sortTracker.runInference(hdResult);
        //long trackRuntime = System.currentTimeMillis() - startTrack;
        //Log.d(LOGTAG +"_checkRuntime", "track time = " + trackRuntime + "ms");

        //TODO: check trackResult is null or not - the first frame in trackSort can be null!!
        List<TrackBox> listTrackBox = new ArrayList<>();
        if (trackResult != null){
            listTrackBox = trackResult.getTrackList();
        }

        /* STEP3: check logic and filter non-human box */

        List<TrackBox> listPassLogicTrack = new ArrayList<>();
        for (TrackBox trackBox : listTrackBox) {
            Bbox currBbox = (Bbox) trackBox.getInferenceResult(box);

            /* motion score packed in motionDetection module */
            long startCaculate = System.currentTimeMillis();
            float motionScore = MotionDetector.getMotionScoreOfTrack(fgMat, trackBox);
            long runtimeCalculate = System.currentTimeMillis() - startCaculate;

            //Log.d(LOGTAG+"_checkRuntime", "runtime motion score calculate = " + runtimeCalculate +"ms");

            boolean[] resultThres = MotionDetector.checkStateMotionImage(motionScore, vibeMode);

            trackBox.setMotionScore(motionScore);

            boolean passMinThres = resultThres[0];
            boolean passAcceptableThres = resultThres[1];

            if (mapTrackTmp.containsKey(trackBox.getTrackID())) {
                TrackBox lastTrackSameId = mapTrackTmp.get(trackBox.getTrackID());

                if (currBbox.getConfidence() > TRUST_THRESHOLD || passAcceptableThres){
                    listPassLogicTrack.add(trackBox);

                    //update track and add new cache bbox
                    mapTrackTmp.get(trackBox.getTrackID()).updateTrackBox(trackBox);
                    mapTrackTmp.get(trackBox.getTrackID()).addBboxToCache(currBbox);
                } else {
                    if (passMinThres){
                        float iou = lastTrackSameId.checkBoxIntersection(currBbox);
                        trackBox.setIouWithFirstCache(iou);
                        if (iou < IOU_THRESHOLD){
                            listPassLogicTrack.add(trackBox);
                        }
                        mapTrackTmp.get(trackBox.getTrackID()).updateTrackBox(trackBox);
                        mapTrackTmp.get(trackBox.getTrackID()).addBboxToCache(currBbox);
                    } else {
                        //TODO: orther detect bbox will be filted here -> free by MediaPool ?? ..
                        //...

                    }
                }
            } else {
                if (currBbox.getConfidence() > TRUST_THRESHOLD){
                    listPassLogicTrack.add(trackBox);
                }
                mapTrackTmp.put(trackBox.getTrackID(), trackBox);
            }
        }

        /* STEP4: remove timeout track in mapTrackTmp*/
        removeTimeoutTmpTrack();

        /* STEP5: Rendering */
        //long startRender = System.currentTimeMillis();
        /*if (EasySharedPreference.getInstance().getIsDrawAi()) {
            Renderer.renderAllBoxHuman(
                    new Canvas(inputInference.getProcessBitmap()),
                    trackResult,
                    listPassLogicTrack,
                    fps
            );
        }*/
        //long renderTime = System.currentTimeMillis() - startRender;
        //Log.d(LOGTAG + "_checkRuntime", "render runtime = " + renderTime + "ms");

        /* Combine result(s) */
        TrackResult finalCombineResult = new TrackResult(inputInference, listPassLogicTrack);
        finalCombineResult.addResult(hdResult);
        finalCombineResult.addResult(motionResult);
        return finalCombineResult;
    }

    private void removeTimeoutTmpTrack(){
        long currentTime = System.currentTimeMillis();

        Iterator<Map.Entry<Integer, TrackBox>> trackEntry = mapTrackTmp.entrySet().iterator();
        while (trackEntry.hasNext()){
            TrackBox trackBox = trackEntry.next().getValue();
            if (currentTime - trackBox.getTimeLife() > TRACK_TIMEOUT){
                trackEntry.remove();
            }
        }
    }

    @Override
    public void onProcessEnd() {
        humanDetector.release();
        sortTracker.release();
    }
}
