package com.securityandsafetythings.examples.aiapp.aicore.aiprocess;

import android.app.Application;
import android.content.Context;
import android.util.Log;

import com.qualcomm.qti.snpe.NeuralNetwork;
import com.securityandsafetythings.examples.aiapp.R;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.Bbox;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.licensePlate.LPDResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.licensePlate.ScrfdLicensePlateDetector;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.vehicle.VDResult;

import java.util.List;
import java.util.Map;

public class AILicencePlateProcessor extends AIProcess{
    static final String LOGTAG = AILicencePlateProcessor.class.getSimpleName();

    private ScrfdLicensePlateDetector licensePlateDetector;

    public AILicencePlateProcessor(Context mContext, Application mApplication, AIProcess nextProcess) {
        super(mContext, mApplication, nextProcess);
        this.setPriority(10);
        this.setName("LPD");
        this.licensePlateDetector = new ScrfdLicensePlateDetector(
                mContext, mApplication, R.raw.scrfd_lpd_500m_bnkps_shape512x512, NeuralNetwork.Runtime.DSP);
    }

    @Override
    public InferenceResult onProcess(InferenceResult inputInference) {
        VDResult vdResult = (VDResult) inputInference;

        Map<String, List<Bbox>> mapVehicleResult = vdResult.getBboxMapResult();

        for (Map.Entry<String, List<Bbox>> listBboxEntry : mapVehicleResult.entrySet()){
            if (!listBboxEntry.getKey().equals("pedestrian")){
                Log.d(LOGTAG, "start check detect plate for class = " + listBboxEntry.getKey());
                for (Bbox bbox : listBboxEntry.getValue()) {
                    LPDResult lpdResult = licensePlateDetector.runInference(bbox);
                    bbox.addResult(lpdResult);
                }
            }
        }

        /*Mat frameRGBA = new Mat();
        Mat frameRgb = new Mat();
        Utils.bitmapToMat(inputInference.getProcessBitmap(), frameRGBA);
        Imgproc.cvtColor(frameRGBA, frameRgb, Imgproc.COLOR_RGBA2RGB);
        lpdResult.setFullFrameRGB(frameRgb);
        licencePlateAligner.runInference(lpdResult);*/

        /* Rendering */
        /*Renderer.renderPlate(
                new Canvas(inputInference.getProcessBitmap()),
                lpdResult,
                fps
        );*/
        //Log.d(LOGTAG, "check output, num plate detect = " + lpdResult.getBboxList().size());
        return vdResult;
    }

    @Override
    public void onProcessEnd() {
        if (licensePlateDetector != null){
            licensePlateDetector.release();
        }
    }
}
