package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference;

import android.graphics.Bitmap;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.Inferrable;

public abstract class ModelInference implements Inferrable {
    protected final int IMAGE_WIDTH;
    protected final int IMAGE_HEIGHT;

    protected ModelInference(int image_width, int image_height) {
        IMAGE_WIDTH = image_width;
        IMAGE_HEIGHT = image_height;
        setModelConfig();
    }

    /** This method for load config model from file config when init model */
    protected abstract void setModelConfig();

    /** These methods use for execute ai-model */
    protected abstract void preProcess(Bitmap inputBitmap);
    protected abstract void preProcess(InferenceResult inferenceResult);
    protected abstract InferenceResult postProcess(InferenceResult inferenceResult);

    public int getImageWidth() {
        return IMAGE_WIDTH;
    }

    public int getImageHeight() {
        return IMAGE_HEIGHT;
    }
}
