package com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.algorithmbasic;

import static com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.extractor.MobileFaceExtractorV2.FEATURE_SIZE;
import static org.opencv.core.CvType.CV_32FC1;

import android.util.Log;

import androidx.annotation.NonNull;

import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.Bbox;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.extractor.Feature;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.sorttrack.TrackBox;


import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat;

import java.util.ArrayList;
import java.util.List;

public class FaceFeatureSearcher extends BasicInference {
    static final String LOGTAG = FaceFeatureSearcher.class.getSimpleName();
    private Mat featuresMatrix;
    private List<String> mLabels = new ArrayList<>();
    private List<String> listLabelIndex = new ArrayList<>();

    //Advanced recognize
    private final List<float[]> mMeanFeatureGroup = new ArrayList<>();

    //Recognize Threshold
    public static final float DISTANCE_ACCEPT = 1.3f;

    /** Callback setup for any change in DB -> need for sync data */
    /*FeatureDynamicStoreCallBack featureDynamicStoreCallBack = new FeatureDynamicStoreCallBack() {
        @Override
        public void onFeatureChange(Mat featuresMatrixCloned, List<String> labelsCopy, List<String> listLabelIndex) {
            syncUpFeatureMatrix(featuresMatrixCloned, labelsCopy, listLabelIndex);
        }

        @Override
        public void onNewRegisterAdded(Mat featuresMatrixCloned, List<String> labelsCopy, List<String> listLabelIndex) {
            syncUpFeatureMatrix(featuresMatrixCloned, labelsCopy, listLabelIndex);
        }
    };*/

    public FaceFeatureSearcher() {
    }

    public void setCallback(){
        //FeatureDynamicStore.getInstance().registerFeatureCallback(featureDynamicStoreCallBack);
    }

    @Override
    /** call by face recognize module return Bbox
     * Input: DetectBbox which contain feature
     * Output: input BBox with FaceRecognizeResult added
     * */
    public Bbox runInference(@NonNull InferenceResult inputInference) {
        Bbox searchBbox = (Bbox) inputInference;
        /*Feature feature = (Feature) searchBbox.getInferenceResult(InferenceResult.ResultName.featureExtracted);
        FaceRecognizeResult faceRecognizeResult = searchFeature(feature);
        searchBbox.addResult(faceRecognizeResult);*/
        return searchBbox;
    }

    /** call by face recognize module return TrackBox
     * Input: TrackBox which contain alignResult
     * Output: FaceRecognizeResult & input TrackBox with FaceRecognizeResult added
     * */
    public FaceRecognizeResult runInference(@NonNull TrackBox inputInference) {
        Feature feature = (Feature) ((TrackBox) inputInference).getInferenceResult(InferenceResult.ResultName.featureExtracted);
        FaceRecognizeResult faceRecognizeResult = searchFeature(feature);
        ((TrackBox) inputInference).addResult(faceRecognizeResult);
        return faceRecognizeResult;
    }

    @NonNull
    private synchronized FaceRecognizeResult searchFeature(@NonNull Feature feature){
        Mat featureMat = feature.getFeatureMat();
        int rows = featuresMatrix.rows();

        FaceRecognizeResult result = new FaceRecognizeResult(feature);
        // If there no feature load from db -> return default unknown
        if (rows == 0) {
            return result;
        }

        //Log.d("_debugSearchFeature", "featuresMatrix: rows= " + rows + " | cols=" + featuresMatrix.cols() + " | info=" + featuresMatrix.dump() );
        //Log.d("_debugSearchFeature", "alignFaceMat: rows= " + featureMat.rows() + " | cols=" + featureMat.cols() + " | info="+ featureMat.dump() );

        //Search feature by opencv
        Mat broad = new Mat(featuresMatrix.rows(), featuresMatrix.cols(), CV_32FC1);
        Core.repeat(featureMat, rows, 1, broad);
        Core.subtract(broad, featuresMatrix, broad);//broad = broad - mFeatures;
        Core.pow(broad,2,broad);
        Core.reduce(broad, broad, 1, 0);//REDUCE_SUM = 0

        Core.MinMaxLocResult minMaxRes = Core.minMaxLoc(broad);
        int index = (int)minMaxRes.minLoc.y;
        result.setMinDistance((float) minMaxRes.minVal);

        if ( minMaxRes.minVal < DISTANCE_ACCEPT) {
            result.setIndex(index);
            result.setLabelId(listLabelIndex.get(index + 1));
            Log.d("_checkFDFlow_checkSearchDevice_recognize", "label= " + mLabels.get(index + 1) +" | distance= " + (float) minMaxRes.minVal);
        } else {
            result.setIndex(-1);
            Log.d("_checkFDFlow_checkSearchDevice_unknown", "label= " + mLabels.get(index + 1) +" | distance= " + (float) minMaxRes.minVal);
        }
        result.setLabel(mLabels.get(result.getIndex() + 1));


        return result;
    }

    public synchronized void syncUpFeatureMatrix(@NonNull Mat featuresMatrix, List<String> labelList, List<String> listLabelIndex){
        this.featuresMatrix = featuresMatrix;
        this.mLabels = labelList;
        this.listLabelIndex = listLabelIndex;
        Log.d(LOGTAG, "check sync up data : featuresMatrix size = " + featuresMatrix.rows() + " labelList = " + labelList);
    }

    /** Need load on app start, onCreate() */
    public void loadFeatureFromDB(){
        //load features from database
        /*Features features = FaceFeatureRepository.getInstance().getListFeature();
        featuresMatrix = new MatOfFloat(features.getData()).reshape(1, features.getSize());

        //load label from database
        mLabels = FaceFeatureRepository.getInstance().getListName();
        listLabelIndex = FaceFeatureRepository.getInstance().getListLabelIndex();*/

        Log.d(LOGTAG, "Model initialized " + " labels " + mLabels.size() + " feature rows " + featuresMatrix.rows() + " features cols " + featuresMatrix.cols());
    }

    public void refreshLabel() {
        //load label from database
        //mLabels = FaceFeatureRepository.getInstance().getListName();
        //listLabelIndex = FaceFeatureRepository.getInstance().getListLabelIndex();

    }

    public void refreshFeature() {
       /* //load features from database
        Features features = FaceFeatureRepository.getInstance().getListFeature();
        featuresMatrix = new MatOfFloat(features.getData()).reshape(1, features.getSize());
        //refresh list label
        refreshLabel();*/

    }

    /** Call this method for immediately add feature to Mat -> no need to load whole db */
    public void addNewFaceFeatureInRuntime(float[] feature, String name){
        Mat featureMat = cvMatFromFloat(feature, 1);
        featuresMatrix.push_back(featureMat);

        /* Make sure face feature added to DB -> refreshLabel will update label list from DB */
        refreshLabel();

    }

    @NonNull
    static public float[] convertFeatureStringToByteArr(@NonNull String strFeature) {
        int index = 0;
        String[] splited = strFeature.split(",");
        //Log.d("Feature size", "" + splited.length);
        float[] featureArr = new float[FEATURE_SIZE];
        for (String tmp : splited) {
            float val = Float.parseFloat(tmp);
            featureArr[index] = val;
            ++index;
        }
        return featureArr;
    }

    private Mat cvMatFromFloat(float[] mat, int mrows) {
        return new MatOfFloat(mat).reshape(1, mrows);
    }

    public void calculateMeanFeatureGroup() {
        //load features by person name
        /*mMeanFeatureGroup.clear();
        List<Integer> listPersonId = FaceFeatureRepository.getInstance().getListPersonIdGroup();
        for (Integer personId : listPersonId) {
            float[] featureArr = FaceFeatureRepository.getInstance().getMeanFeatureById(personId);
            mMeanFeatureGroup.add(featureArr);
        }*/
    }

    public Mat getFeaturesMatrix() {
        return featuresMatrix;
    }

    public List<String> getLabels() {
        return mLabels;
    }

    public List<String> getListLabelIndex() {
        return listLabelIndex;
    }

    @Override
    public void release() {
        //FeatureDynamicStore.getInstance().unregisterCallback(featureDynamicStoreCallBack);
    }
}
