package com.securityandsafetythings.examples.aiapp.aicore.aiprocess;

import android.app.Application;
import android.content.Context;
import android.graphics.Canvas;
import android.util.Log;

import com.qualcomm.qti.snpe.NeuralNetwork;
import com.securityandsafetythings.examples.aiapp.R;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.Bbox;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.licensePlate.LPDResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.vehicle.VDResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.extractor.LicencePlateExtractor;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.extractor.OCRResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.algorithm.nativewarpper.align.LicencePlateAligner;
import com.securityandsafetythings.examples.aiapp.utilities.Renderer;

import java.util.List;
import java.util.Map;

public class AIOCRProcessor extends AIProcess{
    static String LOGTAG = AIOCRProcessor.class.getSimpleName();
    private LicencePlateExtractor licencePlateExtractor;
    private LicencePlateAligner licencePlateAligner;


    public AIOCRProcessor(Context mContext, Application mApplication, AIProcess nextProcess) {
        super(mContext, mApplication, nextProcess);
        this.setPriority(10);
        licencePlateExtractor = new LicencePlateExtractor(mContext, mApplication, R.raw.lprnet_steps470000, NeuralNetwork.Runtime.DSP);
        licencePlateAligner = new LicencePlateAligner(mContext);
        this.setName("LPR");
    }

    @Override
    public InferenceResult onProcess(InferenceResult inputInference) {
        VDResult vdResult = (VDResult) inputInference;
        Map<String, List<Bbox>> mapVehicleResult = vdResult.getBboxMapResult();

        for (Map.Entry<String, List<Bbox>> listBboxEntry : mapVehicleResult.entrySet()){
            if (!listBboxEntry.getKey().equals("pedestrian")){

                Log.d(LOGTAG, "check plate for class = " + listBboxEntry.getKey() + "  | list bbox = " + listBboxEntry.getValue().size());

                for (Bbox bboxVehicle : listBboxEntry.getValue()) {
                    LPDResult lpdResult = (LPDResult) bboxVehicle.getInferenceResult(InferenceResult.ResultName.licencePlateDetect);

                    Log.d(LOGTAG, "check lpdResult for bboxVehicle: " + lpdResult);

                    if (lpdResult != null) {
                        List<Bbox> boxPlateList = lpdResult.getBboxList();

                        Log.d(LOGTAG, "check plateBbox for lprResult: " + boxPlateList);
                        if (boxPlateList != null && !boxPlateList.isEmpty()){
                            Bbox bboxPlate = boxPlateList.get(0);

                            Log.d(LOGTAG, "Start align plate here");
                            licencePlateAligner.runInference(bboxPlate);

                            OCRResult ocrResult = licencePlateExtractor.runInference(bboxPlate);
                            bboxVehicle.addResult(ocrResult);
                        }
                    }

                }
            }
        }

        /* Rendering */
        Renderer.renderAllBoxVehicleOCRPlate(
                new Canvas(inputInference.getProcessBitmap()),
                vdResult,
                fps
        );

        return vdResult;
    }

    @Override
    public void onProcessEnd() {

    }
}
