package com.securityandsafetythings.examples.aiapp.aicore.aiprocess;

import android.app.Application;
import android.content.Context;
import android.graphics.Canvas;

import com.qualcomm.qti.snpe.NeuralNetwork;
import com.securityandsafetythings.examples.aiapp.R;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.InferenceResult;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.vehicle.ScrfdVehicleDetector;
import com.securityandsafetythings.examples.aiapp.aicore.aiLibs.aiInference.detector.vehicle.VDResult;
import com.securityandsafetythings.examples.aiapp.utilities.Renderer;

import kotlin.jvm.Throws;

public class AIVehicleProcessor extends AIProcess{
    static final String LOGTAG = AIVehicleProcessor.class.getSimpleName();

    private ScrfdVehicleDetector vehicleDetector;

    public AIVehicleProcessor(Context mContext, Application mApplication, AIProcess nextProcess) {
        super(mContext, mApplication, nextProcess);
        this.vehicleDetector = new ScrfdVehicleDetector(
                mContext, mApplication, R.raw.scrfd_vehicle_25g_shape512x896, NeuralNetwork.Runtime.DSP);
        this.setPriority(10);
        this.setName("VHD");
    }

    @Override
    public InferenceResult onProcess(InferenceResult inputInference) {
        VDResult vdResult = vehicleDetector.runInference(inputInference);

        /* Rendering */
        Renderer.renderAllBoxVehicle(
                new Canvas(inputInference.getProcessBitmap()),
                vdResult,
                fps
        );
        return vdResult;
    }

    @Override
    public void onProcessEnd() {
        if (vehicleDetector != null){
            vehicleDetector.release();
        }
    }
}
