/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { TemplateRef } from '@angular/core';
/**
 * Element that will be used as a template for the placeholder of a CdkDrag when
 * it is being dragged. The placeholder is displayed in place of the element being dragged.
 */
import * as ɵngcc0 from '@angular/core';
export declare class CdkDragPlaceholder<T = any> {
    templateRef: TemplateRef<T>;
    /** Context data to be added to the placeholder template instance. */
    data: T;
    constructor(templateRef: TemplateRef<T>);
    static ɵfac: ɵngcc0.ɵɵFactoryDef<CdkDragPlaceholder<any>, never>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<CdkDragPlaceholder<any>, "ng-template[cdkDragPlaceholder]", never, { "data": "data"; }, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZHJhZy1wbGFjZWhvbGRlci5kLnRzIiwic291cmNlcyI6WyJkcmFnLXBsYWNlaG9sZGVyLmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7OztBQUNBIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5pbXBvcnQgeyBUZW1wbGF0ZVJlZiB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuLyoqXG4gKiBFbGVtZW50IHRoYXQgd2lsbCBiZSB1c2VkIGFzIGEgdGVtcGxhdGUgZm9yIHRoZSBwbGFjZWhvbGRlciBvZiBhIENka0RyYWcgd2hlblxuICogaXQgaXMgYmVpbmcgZHJhZ2dlZC4gVGhlIHBsYWNlaG9sZGVyIGlzIGRpc3BsYXllZCBpbiBwbGFjZSBvZiB0aGUgZWxlbWVudCBiZWluZyBkcmFnZ2VkLlxuICovXG5leHBvcnQgZGVjbGFyZSBjbGFzcyBDZGtEcmFnUGxhY2Vob2xkZXI8VCA9IGFueT4ge1xuICAgIHRlbXBsYXRlUmVmOiBUZW1wbGF0ZVJlZjxUPjtcbiAgICAvKiogQ29udGV4dCBkYXRhIHRvIGJlIGFkZGVkIHRvIHRoZSBwbGFjZWhvbGRlciB0ZW1wbGF0ZSBpbnN0YW5jZS4gKi9cbiAgICBkYXRhOiBUO1xuICAgIGNvbnN0cnVjdG9yKHRlbXBsYXRlUmVmOiBUZW1wbGF0ZVJlZjxUPik7XG59XG4iXX0=