/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// TODO(jelbourn): move this to live with the rest of the scrolling code
// TODO(jelbourn): someday replace this with IntersectionObservers
/**
 * Gets whether an element is scrolled outside of view by any of its parent scrolling containers.
 * @param element Dimensions of the element (from getBoundingClientRect)
 * @param scrollContainers Dimensions of element's scrolling containers (from getBoundingClientRect)
 * @returns Whether the element is scrolled out of view
 * @docs-private
 */
export function isElementScrolledOutsideView(element, scrollContainers) {
    return scrollContainers.some(function (containerBounds) {
        var outsideAbove = element.bottom < containerBounds.top;
        var outsideBelow = element.top > containerBounds.bottom;
        var outsideLeft = element.right < containerBounds.left;
        var outsideRight = element.left > containerBounds.right;
        return outsideAbove || outsideBelow || outsideLeft || outsideRight;
    });
}
/**
 * Gets whether an element is clipped by any of its scrolling containers.
 * @param element Dimensions of the element (from getBoundingClientRect)
 * @param scrollContainers Dimensions of element's scrolling containers (from getBoundingClientRect)
 * @returns Whether the element is clipped
 * @docs-private
 */
export function isElementClippedByScrolling(element, scrollContainers) {
    return scrollContainers.some(function (scrollContainerRect) {
        var clippedAbove = element.top < scrollContainerRect.top;
        var clippedBelow = element.bottom > scrollContainerRect.bottom;
        var clippedLeft = element.left < scrollContainerRect.left;
        var clippedRight = element.right > scrollContainerRect.right;
        return clippedAbove || clippedBelow || clippedLeft || clippedRight;
    });
}
//# sourceMappingURL=data:application/json;base64,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