/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/// <amd-module name="@angular/compiler-cli/src/ngtsc/shims/src/typecheck_shim" />
import * as ts from 'typescript';
import { AbsoluteFsPath } from '../../file_system';
import { ShimGenerator } from './api';
/**
 * A `ShimGenerator` which adds a type-checking file to the `ts.Program`.
 *
 * This is a requirement for performant template type-checking, as TypeScript will only reuse
 * information in the main program when creating the type-checking program if the set of files in
 * each are exactly the same. Thus, the main program also needs the synthetic type-checking file.
 */
export declare class TypeCheckShimGenerator implements ShimGenerator {
    private typeCheckFile;
    constructor(typeCheckFile: AbsoluteFsPath);
    recognize(fileName: AbsoluteFsPath): boolean;
    generate(genFileName: AbsoluteFsPath, readFile: (fileName: string) => ts.SourceFile | null): ts.SourceFile | null;
}
