/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/metadata/schema", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    // Metadata Schema
    // If you make a backwards incompatible change to the schema, increment the METADTA_VERSION number.
    // If you make a backwards compatible change to the metadata (such as adding an option field) then
    // leave METADATA_VERSION the same. If possible, supply as many versions of the metadata that can
    // represent the semantics of the file in an array. For example, when generating a version 2 file,
    // if version 1 can accurately represent the metadata, generate both version 1 and version 2 in
    // an array.
    exports.METADATA_VERSION = 4;
    function isModuleMetadata(value) {
        return value && value.__symbolic === 'module';
    }
    exports.isModuleMetadata = isModuleMetadata;
    function isClassMetadata(value) {
        return value && value.__symbolic === 'class';
    }
    exports.isClassMetadata = isClassMetadata;
    function isInterfaceMetadata(value) {
        return value && value.__symbolic === 'interface';
    }
    exports.isInterfaceMetadata = isInterfaceMetadata;
    function isMemberMetadata(value) {
        if (value) {
            switch (value.__symbolic) {
                case 'constructor':
                case 'method':
                case 'property':
                    return true;
            }
        }
        return false;
    }
    exports.isMemberMetadata = isMemberMetadata;
    function isMethodMetadata(value) {
        return value && (value.__symbolic === 'constructor' || value.__symbolic === 'method');
    }
    exports.isMethodMetadata = isMethodMetadata;
    function isConstructorMetadata(value) {
        return value && value.__symbolic === 'constructor';
    }
    exports.isConstructorMetadata = isConstructorMetadata;
    function isFunctionMetadata(value) {
        return value && value.__symbolic === 'function';
    }
    exports.isFunctionMetadata = isFunctionMetadata;
    function isMetadataSymbolicExpression(value) {
        if (value) {
            switch (value.__symbolic) {
                case 'binary':
                case 'call':
                case 'index':
                case 'new':
                case 'pre':
                case 'reference':
                case 'select':
                case 'spread':
                case 'if':
                    return true;
            }
        }
        return false;
    }
    exports.isMetadataSymbolicExpression = isMetadataSymbolicExpression;
    function isMetadataSymbolicBinaryExpression(value) {
        return value && value.__symbolic === 'binary';
    }
    exports.isMetadataSymbolicBinaryExpression = isMetadataSymbolicBinaryExpression;
    function isMetadataSymbolicIndexExpression(value) {
        return value && value.__symbolic === 'index';
    }
    exports.isMetadataSymbolicIndexExpression = isMetadataSymbolicIndexExpression;
    function isMetadataSymbolicCallExpression(value) {
        return value && (value.__symbolic === 'call' || value.__symbolic === 'new');
    }
    exports.isMetadataSymbolicCallExpression = isMetadataSymbolicCallExpression;
    function isMetadataSymbolicPrefixExpression(value) {
        return value && value.__symbolic === 'pre';
    }
    exports.isMetadataSymbolicPrefixExpression = isMetadataSymbolicPrefixExpression;
    function isMetadataSymbolicIfExpression(value) {
        return value && value.__symbolic === 'if';
    }
    exports.isMetadataSymbolicIfExpression = isMetadataSymbolicIfExpression;
    function isMetadataGlobalReferenceExpression(value) {
        return value && value.name && !value.module && isMetadataSymbolicReferenceExpression(value);
    }
    exports.isMetadataGlobalReferenceExpression = isMetadataGlobalReferenceExpression;
    function isMetadataModuleReferenceExpression(value) {
        return value && value.module && !value.name && !value.default &&
            isMetadataSymbolicReferenceExpression(value);
    }
    exports.isMetadataModuleReferenceExpression = isMetadataModuleReferenceExpression;
    function isMetadataImportedSymbolReferenceExpression(value) {
        return value && value.module && !!value.name && isMetadataSymbolicReferenceExpression(value);
    }
    exports.isMetadataImportedSymbolReferenceExpression = isMetadataImportedSymbolReferenceExpression;
    function isMetadataImportDefaultReference(value) {
        return value && value.module && value.default && isMetadataSymbolicReferenceExpression(value);
    }
    exports.isMetadataImportDefaultReference = isMetadataImportDefaultReference;
    function isMetadataSymbolicReferenceExpression(value) {
        return value && value.__symbolic === 'reference';
    }
    exports.isMetadataSymbolicReferenceExpression = isMetadataSymbolicReferenceExpression;
    function isMetadataSymbolicSelectExpression(value) {
        return value && value.__symbolic === 'select';
    }
    exports.isMetadataSymbolicSelectExpression = isMetadataSymbolicSelectExpression;
    function isMetadataSymbolicSpreadExpression(value) {
        return value && value.__symbolic === 'spread';
    }
    exports.isMetadataSymbolicSpreadExpression = isMetadataSymbolicSpreadExpression;
    function isMetadataError(value) {
        return value && value.__symbolic === 'error';
    }
    exports.isMetadataError = isMetadataError;
});
//# sourceMappingURL=data:application/json;base64,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