/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/ngtsc/indexer/src/api", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * Describes the kind of identifier found in a template.
     */
    var IdentifierKind;
    (function (IdentifierKind) {
        IdentifierKind[IdentifierKind["Property"] = 0] = "Property";
        IdentifierKind[IdentifierKind["Method"] = 1] = "Method";
        IdentifierKind[IdentifierKind["Element"] = 2] = "Element";
        IdentifierKind[IdentifierKind["Template"] = 3] = "Template";
        IdentifierKind[IdentifierKind["Attribute"] = 4] = "Attribute";
        IdentifierKind[IdentifierKind["Reference"] = 5] = "Reference";
        IdentifierKind[IdentifierKind["Variable"] = 6] = "Variable";
    })(IdentifierKind = exports.IdentifierKind || (exports.IdentifierKind = {}));
    /**
     * Describes the absolute byte offsets of a text anchor in a source code.
     */
    var AbsoluteSourceSpan = /** @class */ (function () {
        function AbsoluteSourceSpan(start, end) {
            this.start = start;
            this.end = end;
        }
        return AbsoluteSourceSpan;
    }());
    exports.AbsoluteSourceSpan = AbsoluteSourceSpan;
});
//# sourceMappingURL=data:application/json;base64,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