/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { makeDecorator } from '../util/decorators';
import { getInjectableDef, ɵɵdefineInjectable } from './interface/defs';
import { compileInjectable as render3CompileInjectable } from './jit/injectable';
import { convertInjectableProviderToFactory } from './util';
var ɵ0 = function (type, meta) { return SWITCH_COMPILE_INJECTABLE(type, meta); };
/**
 * Injectable decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Injectable = makeDecorator('Injectable', undefined, undefined, undefined, ɵ0);
/**
 * Supports @Injectable() in JIT mode for Render2.
 */
function render2CompileInjectable(injectableType, options) {
    if (options && options.providedIn !== undefined && !getInjectableDef(injectableType)) {
        injectableType.ɵprov = ɵɵdefineInjectable({
            token: injectableType,
            providedIn: options.providedIn,
            factory: convertInjectableProviderToFactory(injectableType, options),
        });
    }
}
export var SWITCH_COMPILE_INJECTABLE__POST_R3__ = render3CompileInjectable;
var SWITCH_COMPILE_INJECTABLE__PRE_R3__ = render2CompileInjectable;
var SWITCH_COMPILE_INJECTABLE = SWITCH_COMPILE_INJECTABLE__PRE_R3__;
export { ɵ0 };
//# sourceMappingURL=data:application/json;base64,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