/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { __read, __spread } from "tslib";
import { ɵɵdefineInjector } from '../di/interface/defs';
import { convertInjectableProviderToFactory } from '../di/util';
import { compileNgModule as render3CompileNgModule } from '../render3/jit/module';
import { makeDecorator } from '../util/decorators';
var ɵ0 = function (ngModule) { return ngModule; }, ɵ1 = 
/**
 * Decorator that marks the following class as an NgModule, and supplies
 * configuration metadata for it.
 *
 * * The `declarations` and `entryComponents` options configure the compiler
 * with information about what belongs to the NgModule.
 * * The `providers` options configures the NgModule's injector to provide
 * dependencies the NgModule members.
 * * The `imports` and `exports` options bring in members from other modules, and make
 * this module's members available to others.
 */
function (type, meta) { return SWITCH_COMPILE_NGMODULE(type, meta); };
/**
 * @Annotation
 * @publicApi
 */
export var NgModule = makeDecorator('NgModule', ɵ0, undefined, undefined, ɵ1);
function preR3NgModuleCompile(moduleType, metadata) {
    var imports = (metadata && metadata.imports) || [];
    if (metadata && metadata.exports) {
        imports = __spread(imports, [metadata.exports]);
    }
    moduleType.ɵinj = ɵɵdefineInjector({
        factory: convertInjectableProviderToFactory(moduleType, { useClass: moduleType }),
        providers: metadata && metadata.providers,
        imports: imports,
    });
}
export var SWITCH_COMPILE_NGMODULE__POST_R3__ = render3CompileNgModule;
var SWITCH_COMPILE_NGMODULE__PRE_R3__ = preR3NgModuleCompile;
var SWITCH_COMPILE_NGMODULE = SWITCH_COMPILE_NGMODULE__PRE_R3__;
export { ɵ0, ɵ1 };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmdfbW9kdWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvY29yZS9zcmMvbWV0YWRhdGEvbmdfbW9kdWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRzs7QUFHSCxPQUFPLEVBQWUsZ0JBQWdCLEVBQUMsTUFBTSxzQkFBc0IsQ0FBQztBQUVwRSxPQUFPLEVBQUMsa0NBQWtDLEVBQUMsTUFBTSxZQUFZLENBQUM7QUFHOUQsT0FBTyxFQUFDLGVBQWUsSUFBSSxzQkFBc0IsRUFBQyxNQUFNLHVCQUF1QixDQUFDO0FBQ2hGLE9BQU8sRUFBQyxhQUFhLEVBQWdCLE1BQU0sb0JBQW9CLENBQUM7U0EwU2hELFVBQUMsUUFBa0IsSUFBSyxPQUFBLFFBQVEsRUFBUixDQUFRO0FBQzVDOzs7Ozs7Ozs7O0dBVUc7QUFDSCxVQUFDLElBQWUsRUFBRSxJQUFjLElBQUssT0FBQSx1QkFBdUIsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLEVBQW5DLENBQW1DO0FBakI1RTs7O0dBR0c7QUFDSCxNQUFNLENBQUMsSUFBTSxRQUFRLEdBQXNCLGFBQWEsQ0FDcEQsVUFBVSxNQUFvQyxTQUFTLEVBQUUsU0FBUyxLQVlPLENBQUM7QUEwQjlFLFNBQVMsb0JBQW9CLENBQUMsVUFBcUIsRUFBRSxRQUFtQjtJQUN0RSxJQUFJLE9BQU8sR0FBRyxDQUFDLFFBQVEsSUFBSSxRQUFRLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ25ELElBQUksUUFBUSxJQUFJLFFBQVEsQ0FBQyxPQUFPLEVBQUU7UUFDaEMsT0FBTyxZQUFPLE9BQU8sR0FBRSxRQUFRLENBQUMsT0FBTyxFQUFDLENBQUM7S0FDMUM7SUFFQSxVQUFnQyxDQUFDLElBQUksR0FBRyxnQkFBZ0IsQ0FBQztRQUN4RCxPQUFPLEVBQUUsa0NBQWtDLENBQUMsVUFBVSxFQUFFLEVBQUMsUUFBUSxFQUFFLFVBQVUsRUFBQyxDQUFDO1FBQy9FLFNBQVMsRUFBRSxRQUFRLElBQUksUUFBUSxDQUFDLFNBQVM7UUFDekMsT0FBTyxFQUFFLE9BQU87S0FDakIsQ0FBQyxDQUFDO0FBQ0wsQ0FBQztBQUdELE1BQU0sQ0FBQyxJQUFNLGtDQUFrQyxHQUFHLHNCQUFzQixDQUFDO0FBQ3pFLElBQU0saUNBQWlDLEdBQUcsb0JBQW9CLENBQUM7QUFDL0QsSUFBTSx1QkFBdUIsR0FBa0MsaUNBQWlDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIEluYy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbmltcG9ydCB7QXBwbGljYXRpb25SZWZ9IGZyb20gJy4uL2FwcGxpY2F0aW9uX3JlZic7XG5pbXBvcnQge0luamVjdG9yVHlwZSwgybXJtWRlZmluZUluamVjdG9yfSBmcm9tICcuLi9kaS9pbnRlcmZhY2UvZGVmcyc7XG5pbXBvcnQge1Byb3ZpZGVyfSBmcm9tICcuLi9kaS9pbnRlcmZhY2UvcHJvdmlkZXInO1xuaW1wb3J0IHtjb252ZXJ0SW5qZWN0YWJsZVByb3ZpZGVyVG9GYWN0b3J5fSBmcm9tICcuLi9kaS91dGlsJztcbmltcG9ydCB7VHlwZX0gZnJvbSAnLi4vaW50ZXJmYWNlL3R5cGUnO1xuaW1wb3J0IHtTY2hlbWFNZXRhZGF0YX0gZnJvbSAnLi4vbWV0YWRhdGEvc2NoZW1hJztcbmltcG9ydCB7Y29tcGlsZU5nTW9kdWxlIGFzIHJlbmRlcjNDb21waWxlTmdNb2R1bGV9IGZyb20gJy4uL3JlbmRlcjMvaml0L21vZHVsZSc7XG5pbXBvcnQge21ha2VEZWNvcmF0b3IsIFR5cGVEZWNvcmF0b3J9IGZyb20gJy4uL3V0aWwvZGVjb3JhdG9ycyc7XG5cblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBleHBhbnNpb24gb2YgYW4gYE5nTW9kdWxlYCBpbnRvIGl0cyBzY29wZXMuXG4gKlxuICogQSBzY29wZSBpcyBhIHNldCBvZiBkaXJlY3RpdmVzIGFuZCBwaXBlcyB0aGF0IGFyZSB2aXNpYmxlIGluIGEgcGFydGljdWxhciBjb250ZXh0LiBFYWNoXG4gKiBgTmdNb2R1bGVgIGhhcyB0d28gc2NvcGVzLiBUaGUgYGNvbXBpbGF0aW9uYCBzY29wZSBpcyB0aGUgc2V0IG9mIGRpcmVjdGl2ZXMgYW5kIHBpcGVzIHRoYXQgd2lsbFxuICogYmUgcmVjb2duaXplZCBpbiB0aGUgdGVtcGxhdGVzIG9mIGNvbXBvbmVudHMgZGVjbGFyZWQgYnkgdGhlIG1vZHVsZS4gVGhlIGBleHBvcnRlZGAgc2NvcGUgaXMgdGhlXG4gKiBzZXQgb2YgZGlyZWN0aXZlcyBhbmQgcGlwZXMgZXhwb3J0ZWQgYnkgYSBtb2R1bGUgKHRoYXQgaXMsIG1vZHVsZSBCJ3MgZXhwb3J0ZWQgc2NvcGUgZ2V0cyBhZGRlZFxuICogdG8gbW9kdWxlIEEncyBjb21waWxhdGlvbiBzY29wZSB3aGVuIG1vZHVsZSBBIGltcG9ydHMgQikuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTmdNb2R1bGVUcmFuc2l0aXZlU2NvcGVzIHtcbiAgY29tcGlsYXRpb246IHtkaXJlY3RpdmVzOiBTZXQ8YW55PjsgcGlwZXM6IFNldDxhbnk+O307XG4gIGV4cG9ydGVkOiB7ZGlyZWN0aXZlczogU2V0PGFueT47IHBpcGVzOiBTZXQ8YW55Pjt9O1xuICBzY2hlbWFzOiBTY2hlbWFNZXRhZGF0YVtdfG51bGw7XG59XG5cbi8qKlxuICogQHB1YmxpY0FwaVxuICovXG5leHBvcnQgdHlwZSDJtcm1TmdNb2R1bGVEZWZXaXRoTWV0YTxULCBEZWNsYXJhdGlvbnMsIEltcG9ydHMsIEV4cG9ydHM+ID0gTmdNb2R1bGVEZWY8VD47XG5cbi8qKlxuICogUnVudGltZSBsaW5rIGluZm9ybWF0aW9uIGZvciBOZ01vZHVsZXMuXG4gKlxuICogVGhpcyBpcyB0aGUgaW50ZXJuYWwgZGF0YSBzdHJ1Y3R1cmUgdXNlZCBieSB0aGUgcnVudGltZSB0byBhc3NlbWJsZSBjb21wb25lbnRzLCBkaXJlY3RpdmVzLFxuICogcGlwZXMsIGFuZCBpbmplY3RvcnMuXG4gKlxuICogTk9URTogQWx3YXlzIHVzZSBgybXJtWRlZmluZU5nTW9kdWxlYCBmdW5jdGlvbiB0byBjcmVhdGUgdGhpcyBvYmplY3QsXG4gKiBuZXZlciBjcmVhdGUgdGhlIG9iamVjdCBkaXJlY3RseSBzaW5jZSB0aGUgc2hhcGUgb2YgdGhpcyBvYmplY3RcbiAqIGNhbiBjaGFuZ2UgYmV0d2VlbiB2ZXJzaW9ucy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBOZ01vZHVsZURlZjxUPiB7XG4gIC8qKiBUb2tlbiByZXByZXNlbnRpbmcgdGhlIG1vZHVsZS4gVXNlZCBieSBESS4gKi9cbiAgdHlwZTogVDtcblxuICAvKiogTGlzdCBvZiBjb21wb25lbnRzIHRvIGJvb3RzdHJhcC4gKi9cbiAgYm9vdHN0cmFwOiBUeXBlPGFueT5bXXwoKCkgPT4gVHlwZTxhbnk+W10pO1xuXG4gIC8qKiBMaXN0IG9mIGNvbXBvbmVudHMsIGRpcmVjdGl2ZXMsIGFuZCBwaXBlcyBkZWNsYXJlZCBieSB0aGlzIG1vZHVsZS4gKi9cbiAgZGVjbGFyYXRpb25zOiBUeXBlPGFueT5bXXwoKCkgPT4gVHlwZTxhbnk+W10pO1xuXG4gIC8qKiBMaXN0IG9mIG1vZHVsZXMgb3IgYE1vZHVsZVdpdGhQcm92aWRlcnNgIGltcG9ydGVkIGJ5IHRoaXMgbW9kdWxlLiAqL1xuICBpbXBvcnRzOiBUeXBlPGFueT5bXXwoKCkgPT4gVHlwZTxhbnk+W10pO1xuXG4gIC8qKlxuICAgKiBMaXN0IG9mIG1vZHVsZXMsIGBNb2R1bGVXaXRoUHJvdmlkZXJzYCwgY29tcG9uZW50cywgZGlyZWN0aXZlcywgb3IgcGlwZXMgZXhwb3J0ZWQgYnkgdGhpc1xuICAgKiBtb2R1bGUuXG4gICAqL1xuICBleHBvcnRzOiBUeXBlPGFueT5bXXwoKCkgPT4gVHlwZTxhbnk+W10pO1xuXG4gIC8qKlxuICAgKiBDYWNoZWQgdmFsdWUgb2YgY29tcHV0ZWQgYHRyYW5zaXRpdmVDb21waWxlU2NvcGVzYCBmb3IgdGhpcyBtb2R1bGUuXG4gICAqXG4gICAqIFRoaXMgc2hvdWxkIG5ldmVyIGJlIHJlYWQgZGlyZWN0bHksIGJ1dCBhY2Nlc3NlZCB2aWEgYHRyYW5zaXRpdmVTY29wZXNGb3JgLlxuICAgKi9cbiAgdHJhbnNpdGl2ZUNvbXBpbGVTY29wZXM6IE5nTW9kdWxlVHJhbnNpdGl2ZVNjb3Blc3xudWxsO1xuXG4gIC8qKiBUaGUgc2V0IG9mIHNjaGVtYXMgdGhhdCBkZWNsYXJlIGVsZW1lbnRzIHRvIGJlIGFsbG93ZWQgaW4gdGhlIE5nTW9kdWxlLiAqL1xuICBzY2hlbWFzOiBTY2hlbWFNZXRhZGF0YVtdfG51bGw7XG5cbiAgLyoqIFVuaXF1ZSBJRCBmb3IgdGhlIG1vZHVsZSB3aXRoIHdoaWNoIGl0IHNob3VsZCBiZSByZWdpc3RlcmVkLiAgKi9cbiAgaWQ6IHN0cmluZ3xudWxsO1xufVxuXG4vKipcbiAqIEEgd3JhcHBlciBhcm91bmQgYW4gTmdNb2R1bGUgdGhhdCBhc3NvY2lhdGVzIGl0IHdpdGggdGhlIHByb3ZpZGVycy5cbiAqXG4gKiBAcGFyYW0gVCB0aGUgbW9kdWxlIHR5cGUuIEluIEl2eSBhcHBsaWNhdGlvbnMsIHRoaXMgbXVzdCBiZSBleHBsaWNpdGx5XG4gKiBwcm92aWRlZC5cbiAqXG4gKiBOb3RlIHRoYXQgdXNpbmcgTW9kdWxlV2l0aFByb3ZpZGVycyB3aXRob3V0IGEgZ2VuZXJpYyB0eXBlIGlzIGRlcHJlY2F0ZWQuXG4gKiBUaGUgZ2VuZXJpYyB3aWxsIGJlY29tZSByZXF1aXJlZCBpbiBhIGZ1dHVyZSB2ZXJzaW9uIG9mIEFuZ3VsYXIuXG4gKlxuICogQHB1YmxpY0FwaVxuICovXG5leHBvcnQgaW50ZXJmYWNlIE1vZHVsZVdpdGhQcm92aWRlcnM8XG4gICAgVCA9IGFueSAvKiogVE9ETyhhbHhodWIpOiByZW1vdmUgZGVmYXVsdCB3aGVuIGNhbGxlcnMgcGFzcyBleHBsaWNpdCB0eXBlIHBhcmFtICovPiB7XG4gIG5nTW9kdWxlOiBUeXBlPFQ+O1xuICBwcm92aWRlcnM/OiBQcm92aWRlcltdO1xufVxuXG5cbi8qKlxuICogVHlwZSBvZiB0aGUgTmdNb2R1bGUgZGVjb3JhdG9yIC8gY29uc3RydWN0b3IgZnVuY3Rpb24uXG4gKlxuICogQHB1YmxpY0FwaVxuICovXG5leHBvcnQgaW50ZXJmYWNlIE5nTW9kdWxlRGVjb3JhdG9yIHtcbiAgLyoqXG4gICAqIERlY29yYXRvciB0aGF0IG1hcmtzIGEgY2xhc3MgYXMgYW4gTmdNb2R1bGUgYW5kIHN1cHBsaWVzIGNvbmZpZ3VyYXRpb24gbWV0YWRhdGEuXG4gICAqL1xuICAob2JqPzogTmdNb2R1bGUpOiBUeXBlRGVjb3JhdG9yO1xuICBuZXcob2JqPzogTmdNb2R1bGUpOiBOZ01vZHVsZTtcbn1cblxuLyoqXG4gKiBUeXBlIG9mIHRoZSBOZ01vZHVsZSBtZXRhZGF0YS5cbiAqXG4gKiBAcHVibGljQXBpXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTmdNb2R1bGUge1xuICAvKipcbiAgICogVGhlIHNldCBvZiBpbmplY3RhYmxlIG9iamVjdHMgdGhhdCBhcmUgYXZhaWxhYmxlIGluIHRoZSBpbmplY3RvclxuICAgKiBvZiB0aGlzIG1vZHVsZS5cbiAgICpcbiAgICogQHNlZSBbRGVwZW5kZW5jeSBJbmplY3Rpb24gZ3VpZGVdKGd1aWRlL2RlcGVuZGVuY3ktaW5qZWN0aW9uKVxuICAgKiBAc2VlIFtOZ01vZHVsZSBndWlkZV0oZ3VpZGUvcHJvdmlkZXJzKVxuICAgKlxuICAgKiBAdXNhZ2VOb3Rlc1xuICAgKlxuICAgKiBEZXBlbmRlbmNpZXMgd2hvc2UgcHJvdmlkZXJzIGFyZSBsaXN0ZWQgaGVyZSBiZWNvbWUgYXZhaWxhYmxlIGZvciBpbmplY3Rpb25cbiAgICogaW50byBhbnkgY29tcG9uZW50LCBkaXJlY3RpdmUsIHBpcGUgb3Igc2VydmljZSB0aGF0IGlzIGEgY2hpbGQgb2YgdGhpcyBpbmplY3Rvci5cbiAgICogVGhlIE5nTW9kdWxlIHVzZWQgZm9yIGJvb3RzdHJhcHBpbmcgdXNlcyB0aGUgcm9vdCBpbmplY3RvciwgYW5kIGNhbiBwcm92aWRlIGRlcGVuZGVuY2llc1xuICAgKiB0byBhbnkgcGFydCBvZiB0aGUgYXBwLlxuICAgKlxuICAgKiBBIGxhenktbG9hZGVkIG1vZHVsZSBoYXMgaXRzIG93biBpbmplY3RvciwgdHlwaWNhbGx5IGEgY2hpbGQgb2YgdGhlIGFwcCByb290IGluamVjdG9yLlxuICAgKiBMYXp5LWxvYWRlZCBzZXJ2aWNlcyBhcmUgc2NvcGVkIHRvIHRoZSBsYXp5LWxvYWRlZCBtb2R1bGUncyBpbmplY3Rvci5cbiAgICogSWYgYSBsYXp5LWxvYWRlZCBtb2R1bGUgYWxzbyBwcm92aWRlcyB0aGUgYFVzZXJTZXJ2aWNlYCwgYW55IGNvbXBvbmVudCBjcmVhdGVkXG4gICAqIHdpdGhpbiB0aGF0IG1vZHVsZSdzIGNvbnRleHQgKHN1Y2ggYXMgYnkgcm91dGVyIG5hdmlnYXRpb24pIGdldHMgdGhlIGxvY2FsIGluc3RhbmNlXG4gICAqIG9mIHRoZSBzZXJ2aWNlLCBub3QgdGhlIGluc3RhbmNlIGluIHRoZSByb290IGluamVjdG9yLlxuICAgKiBDb21wb25lbnRzIGluIGV4dGVybmFsIG1vZHVsZXMgY29udGludWUgdG8gcmVjZWl2ZSB0aGUgaW5zdGFuY2UgcHJvdmlkZWQgYnkgdGhlaXIgaW5qZWN0b3JzLlxuICAgKlxuICAgKiAjIyMgRXhhbXBsZVxuICAgKlxuICAgKiBUaGUgZm9sbG93aW5nIGV4YW1wbGUgZGVmaW5lcyBhIGNsYXNzIHRoYXQgaXMgaW5qZWN0ZWQgaW5cbiAgICogdGhlIEhlbGxvV29ybGQgTmdNb2R1bGU6XG4gICAqXG4gICAqIGBgYFxuICAgKiBjbGFzcyBHcmVldGVyIHtcbiAgICogICAgZ3JlZXQobmFtZTpzdHJpbmcpIHtcbiAgICogICAgICByZXR1cm4gJ0hlbGxvICcgKyBuYW1lICsgJyEnO1xuICAgKiAgICB9XG4gICAqIH1cbiAgICpcbiAgICogQE5nTW9kdWxlKHtcbiAgICogICBwcm92aWRlcnM6IFtcbiAgICogICAgIEdyZWV0ZXJcbiAgICogICBdXG4gICAqIH0pXG4gICAqIGNsYXNzIEhlbGxvV29ybGQge1xuICAgKiAgIGdyZWV0ZXI6R3JlZXRlcjtcbiAgICpcbiAgICogICBjb25zdHJ1Y3RvcihncmVldGVyOkdyZWV0ZXIpIHtcbiAgICogICAgIHRoaXMuZ3JlZXRlciA9IGdyZWV0ZXI7XG4gICAqICAgfVxuICAgKiB9XG4gICAqIGBgYFxuICAgKi9cbiAgcHJvdmlkZXJzPzogUHJvdmlkZXJbXTtcblxuICAvKipcbiAgICogVGhlIHNldCBvZiBjb21wb25lbnRzLCBkaXJlY3RpdmVzLCBhbmQgcGlwZXMgKFtkZWNsYXJhYmxlc10oZ3VpZGUvZ2xvc3NhcnkjZGVjbGFyYWJsZSkpXG4gICAqIHRoYXQgYmVsb25nIHRvIHRoaXMgbW9kdWxlLlxuICAgKlxuICAgKiBAdXNhZ2VOb3Rlc1xuICAgKlxuICAgKiBUaGUgc2V0IG9mIHNlbGVjdG9ycyB0aGF0IGFyZSBhdmFpbGFibGUgdG8gYSB0ZW1wbGF0ZSBpbmNsdWRlIHRob3NlIGRlY2xhcmVkIGhlcmUsIGFuZFxuICAgKiB0aG9zZSB0aGF0IGFyZSBleHBvcnRlZCBmcm9tIGltcG9ydGVkIE5nTW9kdWxlcy5cbiAgICpcbiAgICogRGVjbGFyYWJsZXMgbXVzdCBiZWxvbmcgdG8gZXhhY3RseSBvbmUgbW9kdWxlLlxuICAgKiBUaGUgY29tcGlsZXIgZW1pdHMgYW4gZXJyb3IgaWYgeW91IHRyeSB0byBkZWNsYXJlIHRoZSBzYW1lIGNsYXNzIGluIG1vcmUgdGhhbiBvbmUgbW9kdWxlLlxuICAgKiBCZSBjYXJlZnVsIG5vdCB0byBkZWNsYXJlIGEgY2xhc3MgdGhhdCBpcyBpbXBvcnRlZCBmcm9tIGFub3RoZXIgbW9kdWxlLlxuICAgKlxuICAgKiAjIyMgRXhhbXBsZVxuICAgKlxuICAgKiBUaGUgZm9sbG93aW5nIGV4YW1wbGUgYWxsb3dzIHRoZSBDb21tb25Nb2R1bGUgdG8gdXNlIHRoZSBgTmdGb3JgXG4gICAqIGRpcmVjdGl2ZS5cbiAgICpcbiAgICogYGBgamF2YXNjcmlwdFxuICAgKiBATmdNb2R1bGUoe1xuICAgKiAgIGRlY2xhcmF0aW9uczogW05nRm9yXVxuICAgKiB9KVxuICAgKiBjbGFzcyBDb21tb25Nb2R1bGUge1xuICAgKiB9XG4gICAqIGBgYFxuICAgKi9cbiAgZGVjbGFyYXRpb25zPzogQXJyYXk8VHlwZTxhbnk+fGFueVtdPjtcblxuICAvKipcbiAgICogVGhlIHNldCBvZiBOZ01vZHVsZXMgd2hvc2UgZXhwb3J0ZWQgW2RlY2xhcmFibGVzXShndWlkZS9nbG9zc2FyeSNkZWNsYXJhYmxlKVxuICAgKiBhcmUgYXZhaWxhYmxlIHRvIHRlbXBsYXRlcyBpbiB0aGlzIG1vZHVsZS5cbiAgICpcbiAgICogQHVzYWdlTm90ZXNcbiAgICpcbiAgICogQSB0ZW1wbGF0ZSBjYW4gdXNlIGV4cG9ydGVkIGRlY2xhcmFibGVzIGZyb20gYW55XG4gICAqIGltcG9ydGVkIG1vZHVsZSwgaW5jbHVkaW5nIHRob3NlIGZyb20gbW9kdWxlcyB0aGF0IGFyZSBpbXBvcnRlZCBpbmRpcmVjdGx5XG4gICAqIGFuZCByZS1leHBvcnRlZC5cbiAgICogRm9yIGV4YW1wbGUsIGBNb2R1bGVBYCBpbXBvcnRzIGBNb2R1bGVCYCwgYW5kIGFsc28gZXhwb3J0c1xuICAgKiBpdCwgd2hpY2ggbWFrZXMgdGhlIGRlY2xhcmFibGVzIGZyb20gYE1vZHVsZUJgIGF2YWlsYWJsZVxuICAgKiB3aGVyZXZlciBgTW9kdWxlQWAgaXMgaW1wb3J0ZWQuXG4gICAqXG4gICAqICMjIyBFeGFtcGxlXG4gICAqXG4gICAqIFRoZSBmb2xsb3dpbmcgZXhhbXBsZSBhbGxvd3MgTWFpbk1vZHVsZSB0byB1c2UgYW55dGhpbmcgZXhwb3J0ZWQgYnlcbiAgICogYENvbW1vbk1vZHVsZWA6XG4gICAqXG4gICAqIGBgYGphdmFzY3JpcHRcbiAgICogQE5nTW9kdWxlKHtcbiAgICogICBpbXBvcnRzOiBbQ29tbW9uTW9kdWxlXVxuICAgKiB9KVxuICAgKiBjbGFzcyBNYWluTW9kdWxlIHtcbiAgICogfVxuICAgKiBgYGBcbiAgICpcbiAgICovXG4gIGltcG9ydHM/OiBBcnJheTxUeXBlPGFueT58TW9kdWxlV2l0aFByb3ZpZGVyczx7fT58YW55W10+O1xuXG4gIC8qKlxuICAgKiBUaGUgc2V0IG9mIGNvbXBvbmVudHMsIGRpcmVjdGl2ZXMsIGFuZCBwaXBlcyBkZWNsYXJlZCBpbiB0aGlzXG4gICAqIE5nTW9kdWxlIHRoYXQgY2FuIGJlIHVzZWQgaW4gdGhlIHRlbXBsYXRlIG9mIGFueSBjb21wb25lbnQgdGhhdCBpcyBwYXJ0IG9mIGFuXG4gICAqIE5nTW9kdWxlIHRoYXQgaW1wb3J0cyB0aGlzIE5nTW9kdWxlLiBFeHBvcnRlZCBkZWNsYXJhdGlvbnMgYXJlIHRoZSBtb2R1bGUncyBwdWJsaWMgQVBJLlxuICAgKlxuICAgKiBBIGRlY2xhcmFibGUgYmVsb25ncyB0byBvbmUgYW5kIG9ubHkgb25lIE5nTW9kdWxlLlxuICAgKiBBIG1vZHVsZSBjYW4gbGlzdCBhbm90aGVyIG1vZHVsZSBhbW9uZyBpdHMgZXhwb3J0cywgaW4gd2hpY2ggY2FzZSBhbGwgb2YgdGhhdCBtb2R1bGUnc1xuICAgKiBwdWJsaWMgZGVjbGFyYXRpb24gYXJlIGV4cG9ydGVkLlxuICAgKlxuICAgKiBAdXNhZ2VOb3Rlc1xuICAgKlxuICAgKiBEZWNsYXJhdGlvbnMgYXJlIHByaXZhdGUgYnkgZGVmYXVsdC5cbiAgICogSWYgdGhpcyBNb2R1bGVBIGRvZXMgbm90IGV4cG9ydCBVc2VyQ29tcG9uZW50LCB0aGVuIG9ubHkgdGhlIGNvbXBvbmVudHMgd2l0aGluIHRoaXNcbiAgICogTW9kdWxlQSBjYW4gdXNlIFVzZXJDb21wb25lbnQuXG4gICAqXG4gICAqIE1vZHVsZUEgY2FuIGltcG9ydCBNb2R1bGVCIGFuZCBhbHNvIGV4cG9ydCBpdCwgbWFraW5nIGV4cG9ydHMgZnJvbSBNb2R1bGVCXG4gICAqIGF2YWlsYWJsZSB0byBhbiBOZ01vZHVsZSB0aGF0IGltcG9ydHMgTW9kdWxlQS5cbiAgICpcbiAgICogIyMjIEV4YW1wbGVcbiAgICpcbiAgICogVGhlIGZvbGxvd2luZyBleGFtcGxlIGV4cG9ydHMgdGhlIGBOZ0ZvcmAgZGlyZWN0aXZlIGZyb20gQ29tbW9uTW9kdWxlLlxuICAgKlxuICAgKiBgYGBqYXZhc2NyaXB0XG4gICAqIEBOZ01vZHVsZSh7XG4gICAqICAgZXhwb3J0czogW05nRm9yXVxuICAgKiB9KVxuICAgKiBjbGFzcyBDb21tb25Nb2R1bGUge1xuICAgKiB9XG4gICAqIGBgYFxuICAgKi9cbiAgZXhwb3J0cz86IEFycmF5PFR5cGU8YW55PnxhbnlbXT47XG5cbiAgLyoqXG4gICAqIFRoZSBzZXQgb2YgY29tcG9uZW50cyB0byBjb21waWxlIHdoZW4gdGhpcyBOZ01vZHVsZSBpcyBkZWZpbmVkLFxuICAgKiBzbyB0aGF0IHRoZXkgY2FuIGJlIGR5bmFtaWNhbGx5IGxvYWRlZCBpbnRvIHRoZSB2aWV3LlxuICAgKlxuICAgKiBGb3IgZWFjaCBjb21wb25lbnQgbGlzdGVkIGhlcmUsIEFuZ3VsYXIgY3JlYXRlcyBhIGBDb21wb25lbnRGYWN0b3J5YFxuICAgKiBhbmQgc3RvcmVzIGl0IGluIHRoZSBgQ29tcG9uZW50RmFjdG9yeVJlc29sdmVyYC5cbiAgICpcbiAgICogQW5ndWxhciBhdXRvbWF0aWNhbGx5IGFkZHMgY29tcG9uZW50cyBpbiB0aGUgbW9kdWxlJ3MgYm9vdHN0cmFwXG4gICAqIGFuZCByb3V0ZSBkZWZpbml0aW9ucyBpbnRvIHRoZSBgZW50cnlDb21wb25lbnRzYCBsaXN0LiBVc2UgdGhpc1xuICAgKiBvcHRpb24gdG8gYWRkIGNvbXBvbmVudHMgdGhhdCBhcmUgYm9vdHN0cmFwcGVkXG4gICAqIHVzaW5nIG9uZSBvZiB0aGUgaW1wZXJhdGl2ZSB0ZWNobmlxdWVzLCBzdWNoIGFzIGBWaWV3Q29udGFpbmVyUmVmLmNyZWF0ZUNvbXBvbmVudCgpYC5cbiAgICpcbiAgICogQHNlZSBbRW50cnkgQ29tcG9uZW50c10oZ3VpZGUvZW50cnktY29tcG9uZW50cylcbiAgICogQGRlcHJlY2F0ZWQgU2luY2UgOS4wLjAuIFdpdGggSXZ5LCB0aGlzIHByb3BlcnR5IGlzIG5vIGxvbmdlciBuZWNlc3NhcnkuXG4gICAqL1xuICBlbnRyeUNvbXBvbmVudHM/OiBBcnJheTxUeXBlPGFueT58YW55W10+O1xuXG4gIC8qKlxuICAgKiBUaGUgc2V0IG9mIGNvbXBvbmVudHMgdGhhdCBhcmUgYm9vdHN0cmFwcGVkIHdoZW5cbiAgICogdGhpcyBtb2R1bGUgaXMgYm9vdHN0cmFwcGVkLiBUaGUgY29tcG9uZW50cyBsaXN0ZWQgaGVyZVxuICAgKiBhcmUgYXV0b21hdGljYWxseSBhZGRlZCB0byBgZW50cnlDb21wb25lbnRzYC5cbiAgICovXG4gIGJvb3RzdHJhcD86IEFycmF5PFR5cGU8YW55PnxhbnlbXT47XG5cbiAgLyoqXG4gICAqIFRoZSBzZXQgb2Ygc2NoZW1hcyB0aGF0IGRlY2xhcmUgZWxlbWVudHMgdG8gYmUgYWxsb3dlZCBpbiB0aGUgTmdNb2R1bGUuXG4gICAqIEVsZW1lbnRzIGFuZCBwcm9wZXJ0aWVzIHRoYXQgYXJlIG5laXRoZXIgQW5ndWxhciBjb21wb25lbnRzIG5vciBkaXJlY3RpdmVzXG4gICAqIG11c3QgYmUgZGVjbGFyZWQgaW4gYSBzY2hlbWEuXG4gICAqXG4gICAqIEFsbG93ZWQgdmFsdWUgYXJlIGBOT19FUlJPUlNfU0NIRU1BYCBhbmQgYENVU1RPTV9FTEVNRU5UU19TQ0hFTUFgLlxuICAgKlxuICAgKiBAc2VjdXJpdHkgV2hlbiB1c2luZyBvbmUgb2YgYE5PX0VSUk9SU19TQ0hFTUFgIG9yIGBDVVNUT01fRUxFTUVOVFNfU0NIRU1BYFxuICAgKiB5b3UgbXVzdCBlbnN1cmUgdGhhdCBhbGxvd2VkIGVsZW1lbnRzIGFuZCBwcm9wZXJ0aWVzIHNlY3VyZWx5IGVzY2FwZSBpbnB1dHMuXG4gICAqL1xuICBzY2hlbWFzPzogQXJyYXk8U2NoZW1hTWV0YWRhdGF8YW55W10+O1xuXG4gIC8qKlxuICAgKiBBIG5hbWUgb3IgcGF0aCB0aGF0IHVuaXF1ZWx5IGlkZW50aWZpZXMgdGhpcyBOZ01vZHVsZSBpbiBgZ2V0TW9kdWxlRmFjdG9yeWAuXG4gICAqIElmIGxlZnQgYHVuZGVmaW5lZGAsIHRoZSBOZ01vZHVsZSBpcyBub3QgcmVnaXN0ZXJlZCB3aXRoXG4gICAqIGBnZXRNb2R1bGVGYWN0b3J5YC5cbiAgICovXG4gIGlkPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBJZiB0cnVlLCB0aGlzIG1vZHVsZSB3aWxsIGJlIHNraXBwZWQgYnkgdGhlIEFPVCBjb21waWxlciBhbmQgc28gd2lsbCBhbHdheXMgYmUgY29tcGlsZWRcbiAgICogdXNpbmcgSklULlxuICAgKlxuICAgKiBUaGlzIGV4aXN0cyB0byBzdXBwb3J0IGZ1dHVyZSBJdnkgd29yayBhbmQgaGFzIG5vIGVmZmVjdCBjdXJyZW50bHkuXG4gICAqL1xuICBqaXQ/OiB0cnVlO1xufVxuXG4vKipcbiAqIEBBbm5vdGF0aW9uXG4gKiBAcHVibGljQXBpXG4gKi9cbmV4cG9ydCBjb25zdCBOZ01vZHVsZTogTmdNb2R1bGVEZWNvcmF0b3IgPSBtYWtlRGVjb3JhdG9yKFxuICAgICdOZ01vZHVsZScsIChuZ01vZHVsZTogTmdNb2R1bGUpID0+IG5nTW9kdWxlLCB1bmRlZmluZWQsIHVuZGVmaW5lZCxcbiAgICAvKipcbiAgICAgKiBEZWNvcmF0b3IgdGhhdCBtYXJrcyB0aGUgZm9sbG93aW5nIGNsYXNzIGFzIGFuIE5nTW9kdWxlLCBhbmQgc3VwcGxpZXNcbiAgICAgKiBjb25maWd1cmF0aW9uIG1ldGFkYXRhIGZvciBpdC5cbiAgICAgKlxuICAgICAqICogVGhlIGBkZWNsYXJhdGlvbnNgIGFuZCBgZW50cnlDb21wb25lbnRzYCBvcHRpb25zIGNvbmZpZ3VyZSB0aGUgY29tcGlsZXJcbiAgICAgKiB3aXRoIGluZm9ybWF0aW9uIGFib3V0IHdoYXQgYmVsb25ncyB0byB0aGUgTmdNb2R1bGUuXG4gICAgICogKiBUaGUgYHByb3ZpZGVyc2Agb3B0aW9ucyBjb25maWd1cmVzIHRoZSBOZ01vZHVsZSdzIGluamVjdG9yIHRvIHByb3ZpZGVcbiAgICAgKiBkZXBlbmRlbmNpZXMgdGhlIE5nTW9kdWxlIG1lbWJlcnMuXG4gICAgICogKiBUaGUgYGltcG9ydHNgIGFuZCBgZXhwb3J0c2Agb3B0aW9ucyBicmluZyBpbiBtZW1iZXJzIGZyb20gb3RoZXIgbW9kdWxlcywgYW5kIG1ha2VcbiAgICAgKiB0aGlzIG1vZHVsZSdzIG1lbWJlcnMgYXZhaWxhYmxlIHRvIG90aGVycy5cbiAgICAgKi9cbiAgICAodHlwZTogVHlwZTxhbnk+LCBtZXRhOiBOZ01vZHVsZSkgPT4gU1dJVENIX0NPTVBJTEVfTkdNT0RVTEUodHlwZSwgbWV0YSkpO1xuXG4vKipcbiAqIEBkZXNjcmlwdGlvblxuICogSG9vayBmb3IgbWFudWFsIGJvb3RzdHJhcHBpbmcgb2YgdGhlIGFwcGxpY2F0aW9uIGluc3RlYWQgb2YgdXNpbmcgYm9vdHN0cmFwIGFycmF5IGluIEBOZ01vZHVsZVxuICogYW5ub3RhdGlvbi5cbiAqXG4gKiBSZWZlcmVuY2UgdG8gdGhlIGN1cnJlbnQgYXBwbGljYXRpb24gaXMgcHJvdmlkZWQgYXMgYSBwYXJhbWV0ZXIuXG4gKlxuICogU2VlIFtcIkJvb3RzdHJhcHBpbmdcIl0oZ3VpZGUvYm9vdHN0cmFwcGluZykgYW5kIFtcIkVudHJ5IGNvbXBvbmVudHNcIl0oZ3VpZGUvZW50cnktY29tcG9uZW50cykuXG4gKlxuICogQHVzYWdlTm90ZXNcbiAqIGBgYHR5cGVzY3JpcHRcbiAqIGNsYXNzIEFwcE1vZHVsZSBpbXBsZW1lbnRzIERvQm9vdHN0cmFwIHtcbiAqICAgbmdEb0Jvb3RzdHJhcChhcHBSZWY6IEFwcGxpY2F0aW9uUmVmKSB7XG4gKiAgICAgYXBwUmVmLmJvb3RzdHJhcChBcHBDb21wb25lbnQpOyAvLyBPciBzb21lIG90aGVyIGNvbXBvbmVudFxuICogICB9XG4gKiB9XG4gKiBgYGBcbiAqXG4gKiBAcHVibGljQXBpXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRG9Cb290c3RyYXAge1xuICBuZ0RvQm9vdHN0cmFwKGFwcFJlZjogQXBwbGljYXRpb25SZWYpOiB2b2lkO1xufVxuXG5mdW5jdGlvbiBwcmVSM05nTW9kdWxlQ29tcGlsZShtb2R1bGVUeXBlOiBUeXBlPGFueT4sIG1ldGFkYXRhPzogTmdNb2R1bGUpOiB2b2lkIHtcbiAgbGV0IGltcG9ydHMgPSAobWV0YWRhdGEgJiYgbWV0YWRhdGEuaW1wb3J0cykgfHwgW107XG4gIGlmIChtZXRhZGF0YSAmJiBtZXRhZGF0YS5leHBvcnRzKSB7XG4gICAgaW1wb3J0cyA9IFsuLi5pbXBvcnRzLCBtZXRhZGF0YS5leHBvcnRzXTtcbiAgfVxuXG4gIChtb2R1bGVUeXBlIGFzIEluamVjdG9yVHlwZTxhbnk+KS7JtWluaiA9IMm1ybVkZWZpbmVJbmplY3Rvcih7XG4gICAgZmFjdG9yeTogY29udmVydEluamVjdGFibGVQcm92aWRlclRvRmFjdG9yeShtb2R1bGVUeXBlLCB7dXNlQ2xhc3M6IG1vZHVsZVR5cGV9KSxcbiAgICBwcm92aWRlcnM6IG1ldGFkYXRhICYmIG1ldGFkYXRhLnByb3ZpZGVycyxcbiAgICBpbXBvcnRzOiBpbXBvcnRzLFxuICB9KTtcbn1cblxuXG5leHBvcnQgY29uc3QgU1dJVENIX0NPTVBJTEVfTkdNT0RVTEVfX1BPU1RfUjNfXyA9IHJlbmRlcjNDb21waWxlTmdNb2R1bGU7XG5jb25zdCBTV0lUQ0hfQ09NUElMRV9OR01PRFVMRV9fUFJFX1IzX18gPSBwcmVSM05nTW9kdWxlQ29tcGlsZTtcbmNvbnN0IFNXSVRDSF9DT01QSUxFX05HTU9EVUxFOiB0eXBlb2YgcmVuZGVyM0NvbXBpbGVOZ01vZHVsZSA9IFNXSVRDSF9DT01QSUxFX05HTU9EVUxFX19QUkVfUjNfXztcbiJdfQ==