(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('@angular/cdk/table'), require('@angular/material/core'), require('@angular/cdk/coercion'), require('rxjs'), require('rxjs/operators')) :
    typeof define === 'function' && define.amd ? define('@angular/material/table', ['exports', '@angular/core', '@angular/cdk/table', '@angular/material/core', '@angular/cdk/coercion', 'rxjs', 'rxjs/operators'], factory) :
    (global = global || self, factory((global.ng = global.ng || {}, global.ng.material = global.ng.material || {}, global.ng.material.table = {}), global.ng.core, global.ng.cdk.table, global.ng.material.core, global.ng.cdk.coercion, global.rxjs, global.rxjs.operators));
}(this, (function (exports, core, table, core$1, coercion, rxjs, operators) { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    /* global Reflect, Promise */

    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };

    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }

    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    function __rest(s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }

    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }

    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); }
    }

    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
    }

    function __awaiter(thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }

    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_) try {
                if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
                if (y = 0, t) op = [op[0] & 2, t.value];
                switch (op[0]) {
                    case 0: case 1: t = op; break;
                    case 4: _.label++; return { value: op[1], done: false };
                    case 5: _.label++; y = op[1]; op = [0]; continue;
                    case 7: op = _.ops.pop(); _.trys.pop(); continue;
                    default:
                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                        if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                        if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                        if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                        if (t[2]) _.ops.pop();
                        _.trys.pop(); continue;
                }
                op = body.call(thisArg, _);
            } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
            if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
        }
    }

    function __exportStar(m, exports) {
        for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
    }

    function __values(o) {
        var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
        if (m) return m.call(o);
        return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
    }

    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m) return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
        }
        catch (error) { e = { error: error }; }
        finally {
            try {
                if (r && !r.done && (m = i["return"])) m.call(i);
            }
            finally { if (e) throw e.error; }
        }
        return ar;
    }

    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }

    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    };

    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }

    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
        function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
    }

    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    }

    function __asyncValues(o) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
    }

    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
        return cooked;
    };

    function __importStar(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
        result.default = mod;
        return result;
    }

    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Wrapper for the CdkTable with Material design styles.
     */
    var MatTable = /** @class */ (function (_super) {
        __extends(MatTable, _super);
        function MatTable() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            /** Overrides the sticky CSS class set by the `CdkTable`. */
            _this.stickyCssClass = 'mat-table-sticky';
            return _this;
        }
        MatTable.decorators = [
            { type: core.Component, args: [{
                        selector: 'mat-table, table[mat-table]',
                        exportAs: 'matTable',
                        template: table.CDK_TABLE_TEMPLATE,
                        host: {
                            'class': 'mat-table',
                        },
                        providers: [
                            { provide: table.CdkTable, useExisting: MatTable },
                            { provide: table.CDK_TABLE, useExisting: MatTable }
                        ],
                        encapsulation: core.ViewEncapsulation.None,
                        // See note on CdkTable for explanation on why this uses the default change detection strategy.
                        // tslint:disable-next-line:validate-decorators
                        changeDetection: core.ChangeDetectionStrategy.Default,
                        styles: ["mat-table{display:block}mat-header-row{min-height:56px}mat-row,mat-footer-row{min-height:48px}mat-row,mat-header-row,mat-footer-row{display:flex;border-width:0;border-bottom-width:1px;border-style:solid;align-items:center;box-sizing:border-box}mat-row::after,mat-header-row::after,mat-footer-row::after{display:inline-block;min-height:inherit;content:\"\"}mat-cell:first-of-type,mat-header-cell:first-of-type,mat-footer-cell:first-of-type{padding-left:24px}[dir=rtl] mat-cell:first-of-type,[dir=rtl] mat-header-cell:first-of-type,[dir=rtl] mat-footer-cell:first-of-type{padding-left:0;padding-right:24px}mat-cell:last-of-type,mat-header-cell:last-of-type,mat-footer-cell:last-of-type{padding-right:24px}[dir=rtl] mat-cell:last-of-type,[dir=rtl] mat-header-cell:last-of-type,[dir=rtl] mat-footer-cell:last-of-type{padding-right:0;padding-left:24px}mat-cell,mat-header-cell,mat-footer-cell{flex:1;display:flex;align-items:center;overflow:hidden;word-wrap:break-word;min-height:inherit}table.mat-table{border-spacing:0}tr.mat-header-row{height:56px}tr.mat-row,tr.mat-footer-row{height:48px}th.mat-header-cell{text-align:left}[dir=rtl] th.mat-header-cell{text-align:right}th.mat-header-cell,td.mat-cell,td.mat-footer-cell{padding:0;border-bottom-width:1px;border-bottom-style:solid}th.mat-header-cell:first-of-type,td.mat-cell:first-of-type,td.mat-footer-cell:first-of-type{padding-left:24px}[dir=rtl] th.mat-header-cell:first-of-type,[dir=rtl] td.mat-cell:first-of-type,[dir=rtl] td.mat-footer-cell:first-of-type{padding-left:0;padding-right:24px}th.mat-header-cell:last-of-type,td.mat-cell:last-of-type,td.mat-footer-cell:last-of-type{padding-right:24px}[dir=rtl] th.mat-header-cell:last-of-type,[dir=rtl] td.mat-cell:last-of-type,[dir=rtl] td.mat-footer-cell:last-of-type{padding-right:0;padding-left:24px}\n"]
                    }] }
        ];
        return MatTable;
    }(table.CdkTable));

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Cell definition for the mat-table.
     * Captures the template of a column's data row cell as well as cell-specific properties.
     */
    var MatCellDef = /** @class */ (function (_super) {
        __extends(MatCellDef, _super);
        function MatCellDef() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MatCellDef.decorators = [
            { type: core.Directive, args: [{
                        selector: '[matCellDef]',
                        providers: [{ provide: table.CdkCellDef, useExisting: MatCellDef }]
                    },] }
        ];
        return MatCellDef;
    }(table.CdkCellDef));
    /**
     * Header cell definition for the mat-table.
     * Captures the template of a column's header cell and as well as cell-specific properties.
     */
    var MatHeaderCellDef = /** @class */ (function (_super) {
        __extends(MatHeaderCellDef, _super);
        function MatHeaderCellDef() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MatHeaderCellDef.decorators = [
            { type: core.Directive, args: [{
                        selector: '[matHeaderCellDef]',
                        providers: [{ provide: table.CdkHeaderCellDef, useExisting: MatHeaderCellDef }]
                    },] }
        ];
        return MatHeaderCellDef;
    }(table.CdkHeaderCellDef));
    /**
     * Footer cell definition for the mat-table.
     * Captures the template of a column's footer cell and as well as cell-specific properties.
     */
    var MatFooterCellDef = /** @class */ (function (_super) {
        __extends(MatFooterCellDef, _super);
        function MatFooterCellDef() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MatFooterCellDef.decorators = [
            { type: core.Directive, args: [{
                        selector: '[matFooterCellDef]',
                        providers: [{ provide: table.CdkFooterCellDef, useExisting: MatFooterCellDef }]
                    },] }
        ];
        return MatFooterCellDef;
    }(table.CdkFooterCellDef));
    /**
     * Column definition for the mat-table.
     * Defines a set of cells available for a table column.
     */
    var MatColumnDef = /** @class */ (function (_super) {
        __extends(MatColumnDef, _super);
        function MatColumnDef() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MatColumnDef.decorators = [
            { type: core.Directive, args: [{
                        selector: '[matColumnDef]',
                        inputs: ['sticky'],
                        providers: [
                            { provide: table.CdkColumnDef, useExisting: MatColumnDef },
                            { provide: 'MAT_SORT_HEADER_COLUMN_DEF', useExisting: MatColumnDef }
                        ],
                    },] }
        ];
        MatColumnDef.propDecorators = {
            name: [{ type: core.Input, args: ['matColumnDef',] }]
        };
        return MatColumnDef;
    }(table.CdkColumnDef));
    /** Header cell template container that adds the right classes and role. */
    var MatHeaderCell = /** @class */ (function (_super) {
        __extends(MatHeaderCell, _super);
        function MatHeaderCell(columnDef, elementRef) {
            var _this = _super.call(this, columnDef, elementRef) || this;
            elementRef.nativeElement.classList.add("mat-column-" + columnDef.cssClassFriendlyName);
            return _this;
        }
        MatHeaderCell.decorators = [
            { type: core.Directive, args: [{
                        selector: 'mat-header-cell, th[mat-header-cell]',
                        host: {
                            'class': 'mat-header-cell',
                            'role': 'columnheader',
                        },
                    },] }
        ];
        /** @nocollapse */
        MatHeaderCell.ctorParameters = function () { return [
            { type: table.CdkColumnDef },
            { type: core.ElementRef }
        ]; };
        return MatHeaderCell;
    }(table.CdkHeaderCell));
    /** Footer cell template container that adds the right classes and role. */
    var MatFooterCell = /** @class */ (function (_super) {
        __extends(MatFooterCell, _super);
        function MatFooterCell(columnDef, elementRef) {
            var _this = _super.call(this, columnDef, elementRef) || this;
            elementRef.nativeElement.classList.add("mat-column-" + columnDef.cssClassFriendlyName);
            return _this;
        }
        MatFooterCell.decorators = [
            { type: core.Directive, args: [{
                        selector: 'mat-footer-cell, td[mat-footer-cell]',
                        host: {
                            'class': 'mat-footer-cell',
                            'role': 'gridcell',
                        },
                    },] }
        ];
        /** @nocollapse */
        MatFooterCell.ctorParameters = function () { return [
            { type: table.CdkColumnDef },
            { type: core.ElementRef }
        ]; };
        return MatFooterCell;
    }(table.CdkFooterCell));
    /** Cell template container that adds the right classes and role. */
    var MatCell = /** @class */ (function (_super) {
        __extends(MatCell, _super);
        function MatCell(columnDef, elementRef) {
            var _this = _super.call(this, columnDef, elementRef) || this;
            elementRef.nativeElement.classList.add("mat-column-" + columnDef.cssClassFriendlyName);
            return _this;
        }
        MatCell.decorators = [
            { type: core.Directive, args: [{
                        selector: 'mat-cell, td[mat-cell]',
                        host: {
                            'class': 'mat-cell',
                            'role': 'gridcell',
                        },
                    },] }
        ];
        /** @nocollapse */
        MatCell.ctorParameters = function () { return [
            { type: table.CdkColumnDef },
            { type: core.ElementRef }
        ]; };
        return MatCell;
    }(table.CdkCell));

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Header row definition for the mat-table.
     * Captures the header row's template and other header properties such as the columns to display.
     */
    var MatHeaderRowDef = /** @class */ (function (_super) {
        __extends(MatHeaderRowDef, _super);
        function MatHeaderRowDef() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MatHeaderRowDef.decorators = [
            { type: core.Directive, args: [{
                        selector: '[matHeaderRowDef]',
                        providers: [{ provide: table.CdkHeaderRowDef, useExisting: MatHeaderRowDef }],
                        inputs: ['columns: matHeaderRowDef', 'sticky: matHeaderRowDefSticky'],
                    },] }
        ];
        return MatHeaderRowDef;
    }(table.CdkHeaderRowDef));
    /**
     * Footer row definition for the mat-table.
     * Captures the footer row's template and other footer properties such as the columns to display.
     */
    var MatFooterRowDef = /** @class */ (function (_super) {
        __extends(MatFooterRowDef, _super);
        function MatFooterRowDef() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MatFooterRowDef.decorators = [
            { type: core.Directive, args: [{
                        selector: '[matFooterRowDef]',
                        providers: [{ provide: table.CdkFooterRowDef, useExisting: MatFooterRowDef }],
                        inputs: ['columns: matFooterRowDef', 'sticky: matFooterRowDefSticky'],
                    },] }
        ];
        return MatFooterRowDef;
    }(table.CdkFooterRowDef));
    /**
     * Data row definition for the mat-table.
     * Captures the data row's template and other properties such as the columns to display and
     * a when predicate that describes when this row should be used.
     */
    var MatRowDef = /** @class */ (function (_super) {
        __extends(MatRowDef, _super);
        function MatRowDef() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MatRowDef.decorators = [
            { type: core.Directive, args: [{
                        selector: '[matRowDef]',
                        providers: [{ provide: table.CdkRowDef, useExisting: MatRowDef }],
                        inputs: ['columns: matRowDefColumns', 'when: matRowDefWhen'],
                    },] }
        ];
        return MatRowDef;
    }(table.CdkRowDef));
    /** Header template container that contains the cell outlet. Adds the right class and role. */
    var MatHeaderRow = /** @class */ (function (_super) {
        __extends(MatHeaderRow, _super);
        function MatHeaderRow() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MatHeaderRow.decorators = [
            { type: core.Component, args: [{
                        selector: 'mat-header-row, tr[mat-header-row]',
                        template: table.CDK_ROW_TEMPLATE,
                        host: {
                            'class': 'mat-header-row',
                            'role': 'row',
                        },
                        // See note on CdkTable for explanation on why this uses the default change detection strategy.
                        // tslint:disable-next-line:validate-decorators
                        changeDetection: core.ChangeDetectionStrategy.Default,
                        encapsulation: core.ViewEncapsulation.None,
                        exportAs: 'matHeaderRow',
                        providers: [{ provide: table.CdkHeaderRow, useExisting: MatHeaderRow }]
                    }] }
        ];
        return MatHeaderRow;
    }(table.CdkHeaderRow));
    /** Footer template container that contains the cell outlet. Adds the right class and role. */
    var MatFooterRow = /** @class */ (function (_super) {
        __extends(MatFooterRow, _super);
        function MatFooterRow() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MatFooterRow.decorators = [
            { type: core.Component, args: [{
                        selector: 'mat-footer-row, tr[mat-footer-row]',
                        template: table.CDK_ROW_TEMPLATE,
                        host: {
                            'class': 'mat-footer-row',
                            'role': 'row',
                        },
                        // See note on CdkTable for explanation on why this uses the default change detection strategy.
                        // tslint:disable-next-line:validate-decorators
                        changeDetection: core.ChangeDetectionStrategy.Default,
                        encapsulation: core.ViewEncapsulation.None,
                        exportAs: 'matFooterRow',
                        providers: [{ provide: table.CdkFooterRow, useExisting: MatFooterRow }]
                    }] }
        ];
        return MatFooterRow;
    }(table.CdkFooterRow));
    /** Data row template container that contains the cell outlet. Adds the right class and role. */
    var MatRow = /** @class */ (function (_super) {
        __extends(MatRow, _super);
        function MatRow() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MatRow.decorators = [
            { type: core.Component, args: [{
                        selector: 'mat-row, tr[mat-row]',
                        template: table.CDK_ROW_TEMPLATE,
                        host: {
                            'class': 'mat-row',
                            'role': 'row',
                        },
                        // See note on CdkTable for explanation on why this uses the default change detection strategy.
                        // tslint:disable-next-line:validate-decorators
                        changeDetection: core.ChangeDetectionStrategy.Default,
                        encapsulation: core.ViewEncapsulation.None,
                        exportAs: 'matRow',
                        providers: [{ provide: table.CdkRow, useExisting: MatRow }]
                    }] }
        ];
        return MatRow;
    }(table.CdkRow));

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Column that simply shows text content for the header and row cells. Assumes that the table
     * is using the native table implementation (`<table>`).
     *
     * By default, the name of this column will be the header text and data property accessor.
     * The header text can be overridden with the `headerText` input. Cell values can be overridden with
     * the `dataAccessor` input. Change the text justification to the start or end using the `justify`
     * input.
     */
    var MatTextColumn = /** @class */ (function (_super) {
        __extends(MatTextColumn, _super);
        function MatTextColumn() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MatTextColumn.decorators = [
            { type: core.Component, args: [{
                        selector: 'mat-text-column',
                        template: "\n    <ng-container matColumnDef>\n      <th mat-header-cell *matHeaderCellDef [style.text-align]=\"justify\">\n        {{headerText}}\n      </th>\n      <td mat-cell *matCellDef=\"let data\" [style.text-align]=\"justify\">\n        {{dataAccessor(data, name)}}\n      </td>\n    </ng-container>\n  ",
                        encapsulation: core.ViewEncapsulation.None,
                        // Change detection is intentionally not set to OnPush. This component's template will be provided
                        // to the table to be inserted into its view. This is problematic when change detection runs since
                        // the bindings in this template will be evaluated _after_ the table's view is evaluated, which
                        // mean's the template in the table's view will not have the updated value (and in fact will cause
                        // an ExpressionChangedAfterItHasBeenCheckedError).
                        // tslint:disable-next-line:validate-decorators
                        changeDetection: core.ChangeDetectionStrategy.Default
                    }] }
        ];
        return MatTextColumn;
    }(table.CdkTextColumn));

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var EXPORTED_DECLARATIONS = [
        // Table
        MatTable,
        // Template defs
        MatHeaderCellDef,
        MatHeaderRowDef,
        MatColumnDef,
        MatCellDef,
        MatRowDef,
        MatFooterCellDef,
        MatFooterRowDef,
        // Cell directives
        MatHeaderCell,
        MatCell,
        MatFooterCell,
        // Row directives
        MatHeaderRow,
        MatRow,
        MatFooterRow,
        MatTextColumn,
    ];
    var MatTableModule = /** @class */ (function () {
        function MatTableModule() {
        }
        MatTableModule.decorators = [
            { type: core.NgModule, args: [{
                        imports: [
                            table.CdkTableModule,
                            core$1.MatCommonModule,
                        ],
                        exports: [core$1.MatCommonModule, EXPORTED_DECLARATIONS],
                        declarations: EXPORTED_DECLARATIONS,
                    },] }
        ];
        return MatTableModule;
    }());

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Corresponds to `Number.MAX_SAFE_INTEGER`. Moved out into a variable here due to
     * flaky browser support and the value not being defined in Closure's typings.
     */
    var MAX_SAFE_INTEGER = 9007199254740991;
    /**
     * Data source that accepts a client-side data array and includes native support of filtering,
     * sorting (using MatSort), and pagination (using MatPaginator).
     *
     * Allows for sort customization by overriding sortingDataAccessor, which defines how data
     * properties are accessed. Also allows for filter customization by overriding filterTermAccessor,
     * which defines how row data is converted to a string for filter matching.
     *
     * **Note:** This class is meant to be a simple data source to help you get started. As such
     * it isn't equipped to handle some more advanced cases like robust i18n support or server-side
     * interactions. If your app needs to support more advanced use cases, consider implementing your
     * own `DataSource`.
     */
    var MatTableDataSource = /** @class */ (function (_super) {
        __extends(MatTableDataSource, _super);
        function MatTableDataSource(initialData) {
            if (initialData === void 0) { initialData = []; }
            var _this = _super.call(this) || this;
            /** Stream emitting render data to the table (depends on ordered data changes). */
            _this._renderData = new rxjs.BehaviorSubject([]);
            /** Stream that emits when a new filter string is set on the data source. */
            _this._filter = new rxjs.BehaviorSubject('');
            /** Used to react to internal changes of the paginator that are made by the data source itself. */
            _this._internalPageChanges = new rxjs.Subject();
            /**
             * Subscription to the changes that should trigger an update to the table's rendered rows, such
             * as filtering, sorting, pagination, or base data changes.
             */
            _this._renderChangesSubscription = rxjs.Subscription.EMPTY;
            /**
             * Data accessor function that is used for accessing data properties for sorting through
             * the default sortData function.
             * This default function assumes that the sort header IDs (which defaults to the column name)
             * matches the data's properties (e.g. column Xyz represents data['Xyz']).
             * May be set to a custom function for different behavior.
             * @param data Data object that is being accessed.
             * @param sortHeaderId The name of the column that represents the data.
             */
            _this.sortingDataAccessor = function (data, sortHeaderId) {
                var value = data[sortHeaderId];
                if (coercion._isNumberValue(value)) {
                    var numberValue = Number(value);
                    // Numbers beyond `MAX_SAFE_INTEGER` can't be compared reliably so we
                    // leave them as strings. For more info: https://goo.gl/y5vbSg
                    return numberValue < MAX_SAFE_INTEGER ? numberValue : value;
                }
                return value;
            };
            /**
             * Gets a sorted copy of the data array based on the state of the MatSort. Called
             * after changes are made to the filtered data or when sort changes are emitted from MatSort.
             * By default, the function retrieves the active sort and its direction and compares data
             * by retrieving data using the sortingDataAccessor. May be overridden for a custom implementation
             * of data ordering.
             * @param data The array of data that should be sorted.
             * @param sort The connected MatSort that holds the current sort state.
             */
            _this.sortData = function (data, sort) {
                var active = sort.active;
                var direction = sort.direction;
                if (!active || direction == '') {
                    return data;
                }
                return data.sort(function (a, b) {
                    var valueA = _this.sortingDataAccessor(a, active);
                    var valueB = _this.sortingDataAccessor(b, active);
                    // If both valueA and valueB exist (truthy), then compare the two. Otherwise, check if
                    // one value exists while the other doesn't. In this case, existing value should come last.
                    // This avoids inconsistent results when comparing values to undefined/null.
                    // If neither value exists, return 0 (equal).
                    var comparatorResult = 0;
                    if (valueA != null && valueB != null) {
                        // Check if one value is greater than the other; if equal, comparatorResult should remain 0.
                        if (valueA > valueB) {
                            comparatorResult = 1;
                        }
                        else if (valueA < valueB) {
                            comparatorResult = -1;
                        }
                    }
                    else if (valueA != null) {
                        comparatorResult = 1;
                    }
                    else if (valueB != null) {
                        comparatorResult = -1;
                    }
                    return comparatorResult * (direction == 'asc' ? 1 : -1);
                });
            };
            /**
             * Checks if a data object matches the data source's filter string. By default, each data object
             * is converted to a string of its properties and returns true if the filter has
             * at least one occurrence in that string. By default, the filter string has its whitespace
             * trimmed and the match is case-insensitive. May be overridden for a custom implementation of
             * filter matching.
             * @param data Data object used to check against the filter.
             * @param filter Filter string that has been set on the data source.
             * @returns Whether the filter matches against the data
             */
            _this.filterPredicate = function (data, filter) {
                // Transform the data into a lowercase string of all property values.
                var dataStr = Object.keys(data).reduce(function (currentTerm, key) {
                    // Use an obscure Unicode character to delimit the words in the concatenated string.
                    // This avoids matches where the values of two columns combined will match the user's query
                    // (e.g. `Flute` and `Stop` will match `Test`). The character is intended to be something
                    // that has a very low chance of being typed in by somebody in a text field. This one in
                    // particular is "White up-pointing triangle with dot" from
                    // https://en.wikipedia.org/wiki/List_of_Unicode_characters
                    return currentTerm + data[key] + '◬';
                }, '').toLowerCase();
                // Transform the filter by converting it to lowercase and removing whitespace.
                var transformedFilter = filter.trim().toLowerCase();
                return dataStr.indexOf(transformedFilter) != -1;
            };
            _this._data = new rxjs.BehaviorSubject(initialData);
            _this._updateChangeSubscription();
            return _this;
        }
        Object.defineProperty(MatTableDataSource.prototype, "data", {
            /** Array of data that should be rendered by the table, where each object represents one row. */
            get: function () { return this._data.value; },
            set: function (data) { this._data.next(data); },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(MatTableDataSource.prototype, "filter", {
            /**
             * Filter term that should be used to filter out objects from the data array. To override how
             * data objects match to this filter string, provide a custom function for filterPredicate.
             */
            get: function () { return this._filter.value; },
            set: function (filter) { this._filter.next(filter); },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(MatTableDataSource.prototype, "sort", {
            /**
             * Instance of the MatSort directive used by the table to control its sorting. Sort changes
             * emitted by the MatSort will trigger an update to the table's rendered data.
             */
            get: function () { return this._sort; },
            set: function (sort) {
                this._sort = sort;
                this._updateChangeSubscription();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(MatTableDataSource.prototype, "paginator", {
            /**
             * Instance of the MatPaginator component used by the table to control what page of the data is
             * displayed. Page changes emitted by the MatPaginator will trigger an update to the
             * table's rendered data.
             *
             * Note that the data source uses the paginator's properties to calculate which page of data
             * should be displayed. If the paginator receives its properties as template inputs,
             * e.g. `[pageLength]=100` or `[pageIndex]=1`, then be sure that the paginator's view has been
             * initialized before assigning it to this data source.
             */
            get: function () { return this._paginator; },
            set: function (paginator) {
                this._paginator = paginator;
                this._updateChangeSubscription();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Subscribe to changes that should trigger an update to the table's rendered rows. When the
         * changes occur, process the current state of the filter, sort, and pagination along with
         * the provided base data and send it to the table for rendering.
         */
        MatTableDataSource.prototype._updateChangeSubscription = function () {
            var _this = this;
            // Sorting and/or pagination should be watched if MatSort and/or MatPaginator are provided.
            // The events should emit whenever the component emits a change or initializes, or if no
            // component is provided, a stream with just a null event should be provided.
            // The `sortChange` and `pageChange` acts as a signal to the combineLatests below so that the
            // pipeline can progress to the next step. Note that the value from these streams are not used,
            // they purely act as a signal to progress in the pipeline.
            var sortChange = this._sort ?
                rxjs.merge(this._sort.sortChange, this._sort.initialized) :
                rxjs.of(null);
            var pageChange = this._paginator ?
                rxjs.merge(this._paginator.page, this._internalPageChanges, this._paginator.initialized) :
                rxjs.of(null);
            var dataStream = this._data;
            // Watch for base data or filter changes to provide a filtered set of data.
            var filteredData = rxjs.combineLatest([dataStream, this._filter])
                .pipe(operators.map(function (_a) {
                var _b = __read(_a, 1), data = _b[0];
                return _this._filterData(data);
            }));
            // Watch for filtered data or sort changes to provide an ordered set of data.
            var orderedData = rxjs.combineLatest([filteredData, sortChange])
                .pipe(operators.map(function (_a) {
                var _b = __read(_a, 1), data = _b[0];
                return _this._orderData(data);
            }));
            // Watch for ordered data or page changes to provide a paged set of data.
            var paginatedData = rxjs.combineLatest([orderedData, pageChange])
                .pipe(operators.map(function (_a) {
                var _b = __read(_a, 1), data = _b[0];
                return _this._pageData(data);
            }));
            // Watched for paged data changes and send the result to the table to render.
            this._renderChangesSubscription.unsubscribe();
            this._renderChangesSubscription = paginatedData.subscribe(function (data) { return _this._renderData.next(data); });
        };
        /**
         * Returns a filtered data array where each filter object contains the filter string within
         * the result of the filterTermAccessor function. If no filter is set, returns the data array
         * as provided.
         */
        MatTableDataSource.prototype._filterData = function (data) {
            var _this = this;
            // If there is a filter string, filter out data that does not contain it.
            // Each data object is converted to a string using the function defined by filterTermAccessor.
            // May be overridden for customization.
            this.filteredData =
                !this.filter ? data : data.filter(function (obj) { return _this.filterPredicate(obj, _this.filter); });
            if (this.paginator) {
                this._updatePaginator(this.filteredData.length);
            }
            return this.filteredData;
        };
        /**
         * Returns a sorted copy of the data if MatSort has a sort applied, otherwise just returns the
         * data array as provided. Uses the default data accessor for data lookup, unless a
         * sortDataAccessor function is defined.
         */
        MatTableDataSource.prototype._orderData = function (data) {
            // If there is no active sort or direction, return the data without trying to sort.
            if (!this.sort) {
                return data;
            }
            return this.sortData(data.slice(), this.sort);
        };
        /**
         * Returns a paged slice of the provided data array according to the provided MatPaginator's page
         * index and length. If there is no paginator provided, returns the data array as provided.
         */
        MatTableDataSource.prototype._pageData = function (data) {
            if (!this.paginator) {
                return data;
            }
            var startIndex = this.paginator.pageIndex * this.paginator.pageSize;
            return data.slice(startIndex, startIndex + this.paginator.pageSize);
        };
        /**
         * Updates the paginator to reflect the length of the filtered data, and makes sure that the page
         * index does not exceed the paginator's last page. Values are changed in a resolved promise to
         * guard against making property changes within a round of change detection.
         */
        MatTableDataSource.prototype._updatePaginator = function (filteredDataLength) {
            var _this = this;
            Promise.resolve().then(function () {
                var paginator = _this.paginator;
                if (!paginator) {
                    return;
                }
                paginator.length = filteredDataLength;
                // If the page index is set beyond the page, reduce it to the last page.
                if (paginator.pageIndex > 0) {
                    var lastPageIndex = Math.ceil(paginator.length / paginator.pageSize) - 1 || 0;
                    var newPageIndex = Math.min(paginator.pageIndex, lastPageIndex);
                    if (newPageIndex !== paginator.pageIndex) {
                        paginator.pageIndex = newPageIndex;
                        // Since the paginator only emits after user-generated changes,
                        // we need our own stream so we know to should re-render the data.
                        _this._internalPageChanges.next();
                    }
                }
            });
        };
        /**
         * Used by the MatTable. Called when it connects to the data source.
         * @docs-private
         */
        MatTableDataSource.prototype.connect = function () { return this._renderData; };
        /**
         * Used by the MatTable. Called when it is destroyed. No-op.
         * @docs-private
         */
        MatTableDataSource.prototype.disconnect = function () { };
        return MatTableDataSource;
    }(table.DataSource));

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */

    /**
     * Generated bundle index. Do not edit.
     */

    exports.MatCell = MatCell;
    exports.MatCellDef = MatCellDef;
    exports.MatColumnDef = MatColumnDef;
    exports.MatFooterCell = MatFooterCell;
    exports.MatFooterCellDef = MatFooterCellDef;
    exports.MatFooterRow = MatFooterRow;
    exports.MatFooterRowDef = MatFooterRowDef;
    exports.MatHeaderCell = MatHeaderCell;
    exports.MatHeaderCellDef = MatHeaderCellDef;
    exports.MatHeaderRow = MatHeaderRow;
    exports.MatHeaderRowDef = MatHeaderRowDef;
    exports.MatRow = MatRow;
    exports.MatRowDef = MatRowDef;
    exports.MatTable = MatTable;
    exports.MatTableDataSource = MatTableDataSource;
    exports.MatTableModule = MatTableModule;
    exports.MatTextColumn = MatTextColumn;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=material-table.umd.js.map
