/**
 * @fileoverview added by tsickle
 * Generated from: src/material/bottom-sheet/bottom-sheet-animations.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { animate, state, style, transition, trigger, } from '@angular/animations';
import { AnimationCurves, AnimationDurations } from '@angular/material/core';
/**
 * Animations used by the Material bottom sheet.
 * @type {?}
 */
export const matBottomSheetAnimations = {
    /**
     * Animation that shows and hides a bottom sheet.
     */
    bottomSheetState: trigger('state', [
        state('void, hidden', style({ transform: 'translateY(100%)' })),
        state('visible', style({ transform: 'translateY(0%)' })),
        transition('visible => void, visible => hidden', animate(`${AnimationDurations.COMPLEX} ${AnimationCurves.ACCELERATION_CURVE}`)),
        transition('void => visible', animate(`${AnimationDurations.EXITING} ${AnimationCurves.DECELERATION_CURVE}`)),
    ])
};
//# sourceMappingURL=data:application/json;base64,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