/**
 * @fileoverview added by tsickle
 * Generated from: packages/platform-browser-dynamic/src/compiler_reflector.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { getUrlScheme, Identifiers, syntaxError } from '@angular/compiler';
import { ANALYZE_FOR_ENTRY_COMPONENTS, ChangeDetectionStrategy, ChangeDetectorRef, ComponentFactory, ComponentFactoryResolver, ComponentRef, ElementRef, Injector, LOCALE_ID, NgModuleFactory, NgModuleRef, QueryList, Renderer2, SecurityContext, TemplateRef, TRANSLATIONS_FORMAT, ViewContainerRef, ViewEncapsulation, ɵand, ɵccf, ɵcmf, ɵCodegenComponentFactoryResolver, ɵcrt, ɵdid, ɵeld, ɵEMPTY_ARRAY, ɵEMPTY_MAP, ɵinlineInterpolate, ɵinterpolate, ɵmod, ɵmpd, ɵncd, ɵnov, ɵpad, ɵpid, ɵpod, ɵppd, ɵprd, ɵqud, ɵReflectionCapabilities as ReflectionCapabilities, ɵregisterModuleFactory, ɵstringify as stringify, ɵted, ɵunv, ɵvid } from '@angular/core';
/** @type {?} */
export const MODULE_SUFFIX = '';
/** @type {?} */
const builtinExternalReferences = createBuiltinExternalReferencesMap();
export class JitReflector {
    constructor() {
        this.reflectionCapabilities = new ReflectionCapabilities();
    }
    /**
     * @param {?} type
     * @param {?} cmpMetadata
     * @return {?}
     */
    componentModuleUrl(type, cmpMetadata) {
        /** @type {?} */
        const moduleId = cmpMetadata.moduleId;
        if (typeof moduleId === 'string') {
            /** @type {?} */
            const scheme = getUrlScheme(moduleId);
            return scheme ? moduleId : `package:${moduleId}${MODULE_SUFFIX}`;
        }
        else if (moduleId !== null && moduleId !== void 0) {
            throw syntaxError(`moduleId should be a string in "${stringify(type)}". See https://goo.gl/wIDDiL for more information.\n` +
                `If you're using Webpack you should inline the template and the styles, see https://goo.gl/X2J8zc.`);
        }
        return `./${stringify(type)}`;
    }
    /**
     * @param {?} typeOrFunc
     * @return {?}
     */
    parameters(typeOrFunc) {
        return this.reflectionCapabilities.parameters(typeOrFunc);
    }
    /**
     * @param {?} typeOrFunc
     * @return {?}
     */
    tryAnnotations(typeOrFunc) {
        return this.annotations(typeOrFunc);
    }
    /**
     * @param {?} typeOrFunc
     * @return {?}
     */
    annotations(typeOrFunc) {
        return this.reflectionCapabilities.annotations(typeOrFunc);
    }
    /**
     * @param {?} typeOrFunc
     * @return {?}
     */
    shallowAnnotations(typeOrFunc) {
        throw new Error('Not supported in JIT mode');
    }
    /**
     * @param {?} typeOrFunc
     * @return {?}
     */
    propMetadata(typeOrFunc) {
        return this.reflectionCapabilities.propMetadata(typeOrFunc);
    }
    /**
     * @param {?} type
     * @param {?} lcProperty
     * @return {?}
     */
    hasLifecycleHook(type, lcProperty) {
        return this.reflectionCapabilities.hasLifecycleHook(type, lcProperty);
    }
    /**
     * @param {?} type
     * @return {?}
     */
    guards(type) {
        return this.reflectionCapabilities.guards(type);
    }
    /**
     * @param {?} ref
     * @return {?}
     */
    resolveExternalReference(ref) {
        return builtinExternalReferences.get(ref) || ref.runtime;
    }
}
if (false) {
    /**
     * @type {?}
     * @private
     */
    JitReflector.prototype.reflectionCapabilities;
}
/**
 * @return {?}
 */
function createBuiltinExternalReferencesMap() {
    /** @type {?} */
    const map = new Map();
    map.set(Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS, ANALYZE_FOR_ENTRY_COMPONENTS);
    map.set(Identifiers.ElementRef, ElementRef);
    map.set(Identifiers.NgModuleRef, NgModuleRef);
    map.set(Identifiers.ViewContainerRef, ViewContainerRef);
    map.set(Identifiers.ChangeDetectorRef, ChangeDetectorRef);
    map.set(Identifiers.Renderer2, Renderer2);
    map.set(Identifiers.QueryList, QueryList);
    map.set(Identifiers.TemplateRef, TemplateRef);
    map.set(Identifiers.CodegenComponentFactoryResolver, ɵCodegenComponentFactoryResolver);
    map.set(Identifiers.ComponentFactoryResolver, ComponentFactoryResolver);
    map.set(Identifiers.ComponentFactory, ComponentFactory);
    map.set(Identifiers.ComponentRef, ComponentRef);
    map.set(Identifiers.NgModuleFactory, NgModuleFactory);
    map.set(Identifiers.createModuleFactory, ɵcmf);
    map.set(Identifiers.moduleDef, ɵmod);
    map.set(Identifiers.moduleProviderDef, ɵmpd);
    map.set(Identifiers.RegisterModuleFactoryFn, ɵregisterModuleFactory);
    map.set(Identifiers.Injector, Injector);
    map.set(Identifiers.ViewEncapsulation, ViewEncapsulation);
    map.set(Identifiers.ChangeDetectionStrategy, ChangeDetectionStrategy);
    map.set(Identifiers.SecurityContext, SecurityContext);
    map.set(Identifiers.LOCALE_ID, LOCALE_ID);
    map.set(Identifiers.TRANSLATIONS_FORMAT, TRANSLATIONS_FORMAT);
    map.set(Identifiers.inlineInterpolate, ɵinlineInterpolate);
    map.set(Identifiers.interpolate, ɵinterpolate);
    map.set(Identifiers.EMPTY_ARRAY, ɵEMPTY_ARRAY);
    map.set(Identifiers.EMPTY_MAP, ɵEMPTY_MAP);
    map.set(Identifiers.viewDef, ɵvid);
    map.set(Identifiers.elementDef, ɵeld);
    map.set(Identifiers.anchorDef, ɵand);
    map.set(Identifiers.textDef, ɵted);
    map.set(Identifiers.directiveDef, ɵdid);
    map.set(Identifiers.providerDef, ɵprd);
    map.set(Identifiers.queryDef, ɵqud);
    map.set(Identifiers.pureArrayDef, ɵpad);
    map.set(Identifiers.pureObjectDef, ɵpod);
    map.set(Identifiers.purePipeDef, ɵppd);
    map.set(Identifiers.pipeDef, ɵpid);
    map.set(Identifiers.nodeValue, ɵnov);
    map.set(Identifiers.ngContentDef, ɵncd);
    map.set(Identifiers.unwrapValue, ɵunv);
    map.set(Identifiers.createRendererType2, ɵcrt);
    map.set(Identifiers.createComponentFactory, ɵccf);
    return map;
}
//# sourceMappingURL=data:application/json;base64,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