import { Component, OnInit } from '@angular/core';
import { MatSliderChange } from '@angular/material/slider';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { SettingsDTO } from './setting-interface';
import { MatSnackBar } from '@angular/material/snack-bar';

@Component({
  selector: 'app-setting',
  templateUrl: './setting.component.html',
  styleUrls: ['./setting.component.css']
})
export class SettingComponent implements OnInit {
  sliderValue = 0;

  snackBarConf = {
    duration: 3000
  }

  constructor(
    private httpClient: HttpClient,
    private snackBar: MatSnackBar
  ) { }

  ngOnInit(): void {
    this.getSettings();
  }

  onChange(e: MatSliderChange): void {
    this.sliderValue = e.value;
  }

  getSettings(): void {
    this.httpClient.get('rest/example/settings')
      .subscribe((res: any) => {
        let settings: SettingsDTO = res.data;
        this.sliderValue = settings.confidence;
      },
      err => {
        this.snackBar.open('Sync settings failed!!!', 'Close', this.snackBarConf);
      });
  }

  postSettings(): void {
    let settings: SettingsDTO = {
      confidence: this.sliderValue
    }

    this.httpClient.post('rest/example/settings',
      settings,
      {
        headers: new HttpHeaders().append('Content Type', 'application/json')
      })
      .subscribe((res: any) => {
        this.snackBar.open('Setting updated!!!', 'Close', this.snackBarConf);
      },
      err => {
        this.snackBar.open('Setting update failed', 'Close', this.snackBarConf);
      });
  }
}
