# CVAT Annotation Rule

## Annotation Target

Only annotate the upper half of the body.

## Annotation Rule

* Annotate **upper half of the body**, as tight as possible
  * Thanh's gut feeling: "It will loosen up after training"

* Visibility rule
  Only annotate if **all** of these rules are satisfied

  * Head must be visible
  * The visible part of the upper half of the body must be larger than 50% of the upper body
    * Example: if the stomach is not visible, the person can still be annotated, because the stomach usually only takes up 1/3 the size of the upper body, so the visible part is 2/3
  * The person must not be too small

* Bounding box rule
  * Bottom edge:
    * Aligns with the horizontal belt line:
  
      ![Straight belt](http://192.168.0.101:8929/nvmnghia/cvat-annotation-rule/raw/master/straight%20belt.png)

    * Touches the top point of the oblique belt line:

      ![Oblique belt](http://192.168.0.101:8929/nvmnghia/cvat-annotation-rule/raw/master/oblique%20belt.png)

  * If some parts of the upper half are hidden (by shelves,...), **imagine the belt line** and annotate
    * The above rules of "straight belt" and "oblique belt" still apply

  * Top edge touches the head

  * Side edges:
    * If the person is straight up: Side edges must touch the top notch of the shoulders, not the whole arm, and
    * If the person is oblique: Side edges must touch the furthest point of the body, meaning that background in this case is acceptable:

    ![Oblique body](http://192.168.0.101:8929/nvmnghia/cvat-annotation-rule/raw/master/oblique%20standing.png)

  * Height must be more than 1/8 of the frame's height
    * Use CVAT's grid feature

