package endpoint

import (
	"context"
	"github.com/go-kit/kit/endpoint"
	"go.opentelemetry.io/otel/trace"
	"otel_microservice_test/service"
)

type LogEndpoints struct {
	NewLogEndpoint endpoint.Endpoint
}

func MakeServerLogEndpoint(logsvc service.LogService, tracer trace.Tracer) LogEndpoints {
	return LogEndpoints{
		NewLogEndpoint: MakeLogEndpoint(logsvc, tracer),
	}
}

func MakeLogEndpoint(logsvc service.LogService, tracer trace.Tracer) endpoint.Endpoint {
	return func(ctx context.Context, request interface{}) (response interface{}, err error) {
		ctx, span := tracer.Start(context.Background(), "HTTP GET /endpoint/makelog")
		defer span.End()
		req := request.(service.LogReq)
		logRes, err := logsvc.GetLog(ctx, req.Key, tracer)

		if err != nil {
			return nil, err
		}
		return service.LogRes{
			Id:    logRes.Id,
			Key:   logRes.Key,
			Value: logRes.Value,
		}, nil
	}
}

func (l LogEndpoints) GetLog(ctx context.Context, key string, tracer trace.Tracer) (service.LogRes, error) {
	ctx2, span := tracer.Start(ctx, "HTTP GET /endpoint/getlog")
	defer span.End()
	res, err := l.NewLogEndpoint(ctx2, service.LogReq{
		Key: key,
	})
	if err != nil {
		return service.LogRes{}, err
	}
	response := res.(service.LogRes)
	return response, err
}
