package endpoint

import (
	"context"
	"github.com/go-kit/kit/endpoint"
	"go.opentelemetry.io/otel/trace"
	"otel_microservice_test/service"
)

type TestEndpoint struct {
	TestEndpoint endpoint.Endpoint
}

func MakeServerEndpoint(s service.Service, tracer trace.Tracer) TestEndpoint {
	return TestEndpoint{
		TestEndpoint: MakeTestEndpoint(s, tracer),
	}
}

func MakeTestEndpoint(s service.Service, tracer trace.Tracer) endpoint.Endpoint {
	return func(ctx context.Context, request interface{}) (response interface{}, err error) {
		ctx, span := tracer.Start(context.Background(), "HTTP GET /endpoint/test")
		defer span.End()
		err = s.Test(ctx)
		if err != nil {
			return nil, err
		}
		return Response{
			Message: "Test server",
			Err:     nil,
		}, nil
	}
}

func (r Response) Failed() error { return r.Err }

type Response struct {
	Message string `json:"message"`
	Err     error  `json:"err"`
}
