package service

import (
	"context"
	"go.opentelemetry.io/otel/trace"
	"time"
)

type Service interface {
	Test(ctx context.Context) error
}

type service struct {
	tracer trace.Tracer
}

func NewService(tracer trace.Tracer) Service {
	return &service{
		tracer: tracer,
	}
}

func (s *service) Test(ctx context.Context) error {
	ctx, span := s.tracer.Start(ctx, "HTTP GET /service/test")
	defer span.End()
	time.Sleep(time.Millisecond * 2000)
	s.Test2(ctx)
	return nil
}

func (s *service) Test2(ctx context.Context) {
	_, span := s.tracer.Start(ctx, "HTTP GET /service/test2")
	defer span.End()
	time.Sleep(time.Second)
}
