package transport

import (
	"context"
	grpcTransport "github.com/go-kit/kit/transport/grpc"
	"go.opentelemetry.io/otel/trace"
	"google.golang.org/grpc"
	"otel_microservice_test/endpoint"
	"otel_microservice_test/pb"
	"otel_microservice_test/service"
)

func NewGRPCClient(conn *grpc.ClientConn, tracer trace.Tracer) service.LogService {
	var options []grpcTransport.ClientOption

	logEndpoint := grpcTransport.NewClient(
		conn,
		"pb.LogService",
		"GetLog",
		encodeGRPCNewLogRequest,
		decodeGRPCNewLogResponse,
		pb.LogRes{},
		options...,
	).Endpoint()

	return endpoint.LogEndpoints{
		NewLogEndpoint: logEndpoint,
	}
}
func encodeGRPCNewLogRequest(_ context.Context, grpcReq interface{}) (interface{}, error) {
	req := grpcReq.(service.LogReq)
	return &pb.LogReq{
		Key: req.Key,
	}, nil
}
func decodeGRPCNewLogResponse(_ context.Context, response interface{}) (interface{}, error) {
	resp := response.(*pb.LogRes)
	return service.LogRes{
		Id:    resp.Id,
		Key:   resp.Key,
		Value: resp.Value,
	}, nil
}
