package com.tuya.appsdk.sample.device.mgt

import android.text.Html
import android.text.TextUtils
import java.util.Locale
import kotlin.math.pow

/**
 * create by dongdaqing[mibo] 2023/9/20 11:33
 */
private val DEFAULT_ICON_FONT_MAP = mapOf(
    "icon-dp_add" to "e600",
    "icon-dp_reduce" to "e601",
    "icon-dp_temp" to "e602",
    "icon-dp_time3" to "e603",
    "icon-dp_mode" to "e604",
    "icon-dp_loop" to "e605",
    "icon-dp_filter" to "e606",
    "icon-dp_smile" to "e607",
    "icon-dp_sleep" to "e608",
    "icon-dp_dust" to "e609",
    "icon-eco" to "e60a",
    "icon-eoc2" to "e60b",
    "icon-dp_tvoc" to "e60c",
    "icon-dp_smart" to "e60d",
    "icon-dp_o2" to "e60e",
    "icon-dp_time2" to "e60f",
    "icon-dp_light2" to "e610",
    "icon-dp_shake" to "e611",
    "icon-dp_home2" to "e612",
    "icon-dp_direction" to "e613",
    "icon-dp_power3" to "e614",
    "icon-dp_wash" to "e615",
    "icon-dp_location" to "e616",
    "icon-dp_battery" to "e617",
    "icon-dp_wind" to "e618",
    "icon-dp_fresh" to "e619",
    "icon-dp_wet2" to "e61a",
    "icon-dp_half" to "e61b",
    "icon-dp_sun" to "e61c",
    "icon-dp_bag" to "e61d",
    "icon-dp_wet" to "e61e",
    "icon-dp_water" to "e61f",
    "icon-dp_lock" to "e620",
    "icon-dp_time" to "e621",
    "icon-dp_light" to "e622",
    "icon-dp_0" to "e623",
    "icon-dp_1" to "e624",
    "icon-dp_2" to "e625",
    "icon-dp_3" to "e626",
    "icon-dp_4" to "e627",
    "icon-dp_5" to "e628",
    "icon-dp_6" to "e629",
    "icon-dp_7" to "e62a",
    "icon-dp_8" to "e62b",
    "icon-dp_9" to "e62c",
    "icon-dp_c" to "e62d",
    "icon-dp_f" to "e62e",
    "icon-dp_power2" to "e62f",
    "icon-dp_power" to "e630",
    "icon-dp_right" to "e631",
    "icon-dp_dot" to "e632",
    "icon-dp_play" to "e633",
    "icon-dp_pause" to "e634",
    "icon-dp_down" to "e635",
    "icon-dp_anti-clockwise" to "e636",
    "icon-dp_clockwise" to "e637",
    "icon-dp_up" to "e638",
    "icon-dp_lightning" to "e63a",
    "icon-dp_voice" to "e639",
    "icon-dp_down1" to "e63b",
    "icon-dp_cloud" to "e63c",
    "icon-dp_upload" to "e63d",
    "icon-dp_doc" to "e63e",
    "icon-dp_curve" to "e63f",
    "icon-dp_heart" to "e640",
    "icon-dp_email" to "e641",
    "icon-dp_circle" to "e642",
    "icon-dp_plus" to "e643",
    "icon-dp_home" to "e644",
    "icon-dp_magnifier" to "e645",
    "icon-dp_fly" to "e646",
    "icon-dp_i" to "e647",
    "icon-dp_down2" to "e648",
    "icon-dp_book" to "e649",
    "icon-dp_rabbish" to "e64a",
    "icon-dp_hill" to "e64b",
    "icon-dp_compass" to "e64c",
    "icon-dp_gift" to "e64d",
    "icon-dp_eye" to "e64e",
    "icon-dp_notice" to "e64f",
    "icon-dp_camera" to "e650",
    "icon-dp_puzzle" to "e651",
    "icon-dp_ratio" to "e652",
    "icon-dp_block" to "e653",
    "icon-dp_chat" to "e654",
    "icon-dp_list2" to "e655",
    "icon-dp_bottle" to "e656",
    "icon-dp_doc2" to "e657",
    "icon-dp_what" to "e658",
    "icon-dp_warming" to "e659",
    "icon-dp_updown" to "e65a",
    "icon-dp_tool" to "e65b",
    "icon-dp_tag" to "e65c",
    "icon-dp_shield" to "e65d",
    "icon-dp_box2" to "e65e",
    "icon-dp_box" to "e65f",
    "icon-dp_money" to "e660",
    "icon-dp_house" to "e661",
    "icon-dp_mic" to "e662",
    "icon-dp_calendar" to "e663",
    "icon-dp_list" to "e664",
    "icon-dp_flag" to "e665",
    "icon-dp_flower" to "e666",
    "icon-baifeng" to "e8c1",
    "icon-chushi" to "e8c2",
    "icon-chengzhong" to "e8c3",
    "icon-chongnai" to "e8c4",
    "icon-chushi1" to "e8c5",
    "icon-chushi2" to "e8c6",
    "icon-cuowu" to "e8c7",
    "icon-deng" to "e8c8",
    "icon-dianliang" to "e8c9",
    "icon-fengli" to "e8ca",
    "icon-geren" to "e8cb",
    "icon-gaodiyin" to "e8cc",
    "icon-gongneng" to "e8cd",
    "icon-guanjia" to "e8ce",
    "icon-huoyan" to "e8cf",
    "icon-qita" to "e8d0",
    "icon-jiare" to "e8d1",
    "icon-liangdu" to "e8d2",
    "icon-jiare1" to "e8d3",
    "icon-shangsheng" to "e8d4",
    "icon-shouji" to "e8d5",
    "icon-shoucang" to "e8d6",
    "icon-shezhi" to "e8d7",
    "icon-qiangli" to "e8d8",
    "icon-tianjia" to "e8d9",
    "icon-shoushimima" to "e8da",
    "icon-shenghua" to "e8db",
    "icon-shuibeng" to "e8dc",
    "icon-tongji" to "e8dd",
    "icon-tongji1" to "e8de",
    "icon-yinshui" to "e8df",
    "icon-yinliang" to "e8e0",
    "icon-yanse" to "e8e1",
    "icon-wendu" to "e8e2",
    "icon-yundong" to "e8e3",
    "icon-yunhang" to "e8e4",
    "icon-zanting" to "e8e5",
    "icon-zhengque" to "e8e6",
    "icon-zhuangtai" to "e8e7",
    "icon-zhileng" to "e8e8",
    "icon-zhileng1" to "e8e9",
    "icon-chushuang" to "e8ea",
    "icon-zanting1" to "e8eb",
    "icon-tongji2" to "e8ec",
    "icon-baifeng1" to "e8ed",
    "icon-set" to "e931",
    "icon-yueliang" to "e932",
    "icon-xue" to "e933",
    "icon-fangzi" to "e934",
    "icon-wendu1" to "e935",
    "icon-taiyang" to "e936",
    "icon-fangzi1" to "e937",
    "icon-icon-percent" to "e938",
    "icon-p6" to "e9aa",
    "icon-p7" to "e9ab",
    "icon-p8" to "e9ac",
    "icon-p9" to "e9ad",
    "icon-p10" to "e9ae",
    "icon-p11" to "e9af",
    "icon-p12" to "e9b0",
    "icon-p13" to "e9b1",
    "icon-p14" to "e9b2",
    "icon-p15" to "e9b3",
    "icon-ziyouchengxu" to "e9b4",
    "icon-zhouchengxu" to "e9b5",
    "icon-minus" to "e9ba",
    "icon-plus" to "e9bb",
    "icon-a_fan_low" to "e9bd",
    "icon-a_fan_auto" to "e9be",
    "icon-a_fan_med" to "e9bf",
    "icon-a_fan_high" to "e9c0",
    "icon-a_function_celsius" to "e9c1",
    "icon-a_function_fahrenhei" to "e9c2",
    "icon-a_function_hs" to "e9c3",
    "icon-a_function_eco" to "e9c4",
    "icon-a_function_filter" to "e9c5",
    "icon-a_function_sleep" to "e9c6",
    "icon-a_function_pump" to "e9c7",
    "icon-a_function_vs" to "e9c8",
    "icon-a_function_turbo" to "e9c9",
    "icon-a_mode_basement" to "e9ca",
    "icon-a_mode_continuous" to "e9cb",
    "icon-a_mode_cool" to "e9cc",
    "icon-a_mode_fan" to "e9cd",
    "icon-a_mode_clothes" to "e9ce",
    "icon-a_mode_feel" to "e9cf",
    "icon-a_mode_heat" to "e9d0",
    "icon-a_mode_livingroom" to "e9d1",
    "icon-a_mode_dry" to "e9d2",
    "icon-a_nav_fan" to "e9d3",
    "icon-a_nav_function" to "e9d4",
    "icon-a_nav_mode" to "e9d5",
    "icon-a_power" to "e9d6",
    "icon-a_mode_turbo" to "e9d7",
    "icon-a_nav_timer" to "e9d8",
    "icon-a_down" to "e9d9",
    "icon-a_up" to "e9da",
    "icon-a_water" to "e9db",
    "icon-a_selected" to "e9dc",
    "icon-Mute" to "e9dd",
    "icon-FanSpeed" to "e9de",
    "icon-Lamp" to "e9df",
    "icon-Heal" to "e9e0",
    "icon-Ele" to "e9e1",
    "icon-Strong" to "e9e2",
    "icon-dp_bag1" to "e9e3",
    "icon-off" to "e9e4",
    "icon-edit" to "e9e5",
    "icon-on" to "e9e6",
    "icon-timer" to "e9e7",
    "icon-power" to "e9e8",
    "icon-timer1" to "e9ea",
    "icon-Disarm" to "e9e9",
    "icon-SystemReady" to "e9eb",
    "icon-Arm" to "e9ec",
    "icon-HomeArm" to "e9ed",
    "icon-AwayArm" to "e9ee",
    "icon-power1" to "e9ef",
    "icon-Panic" to "e9f0",
    "icon-battery" to "e9f1",
    "icon-setting" to "e9f2",
    "icon-Trigger" to "e9f3",
    "icon-CMS" to "e9f4",
    "icon-tcl_function_eco" to "ea17",
    "icon-tcl_function_vs" to "ea18",
    "icon-tcl_mode_shoes" to "ea19",
    "icon-tcl_function_hs" to "ea1a",
    "icon-tcl_function_vs1" to "ea1b",
    "icon-tcl_function_vs2" to "ea1c",
    "icon-tcl_function_light" to "ea1d",
    "icon-tcl_function_vs3" to "ea1e",
    "icon-function_eh" to "ea22",
    "icon-air_quality" to "ea23",
    "icon-sound" to "ea24",
    "icon-icon-test6" to "e819",
    "icon-icon-test7" to "e81a",
    "icon-icon-test8" to "e81c",
    "icon-icon-test9" to "e81d",
    "icon-icon-test10" to "e81e",
    "icon-gongnuan" to "e820",
    "icon-lengnuan" to "e821",
    "icon-icon-test11" to "eaa8",
    "icon-zidong" to "eaa9",
    "icon-icon-test12" to "eaaa",
    "icon-icon-test13" to "eaab",
    "icon-xiegang" to "ea96",
    "icon-a_selected-copy" to "eaac",
    "icon-dp_play-copy" to "eaad",
    "icon-jiaquan" to "eb05",
    "icon-baojing" to "eb06",
    "icon-menci" to "eb07",
    "icon-shidu" to "eb08",
    "icon-ranqi" to "eb09",
    "icon-renxingyidong" to "eb0a",
    "icon-zhendong" to "eb0b",
    "icon-wendu2" to "eb0c",
    "icon-yanwu" to "eb0d",
    "icon-liangdu1" to "eb0e",
    "icon-pm" to "eb0f",
    "icon-voc" to "eb10",
    "icon-CH" to "eb28",
    "icon-gongneng1" to "eb29",
    "icon-CO" to "eb2a",
    "icon-yali" to "eb2b",
    "icon-Light" to "eb2c",
    "icon-CO1" to "eb2d",
    "icon-chanpin" to "e87b"
)

fun getIconFontContent(name: String?): CharSequence? {
    return if (name == null) {
        null
    } else {
        val content = DEFAULT_ICON_FONT_MAP[name] ?: return null
        val real = convert(content)
        if (TextUtils.isEmpty(real)) {
            null
        } else {
            Html.fromHtml(real)
        }
    }
}

private fun convert(str: String): String {
    val value = str.lowercase(Locale.getDefault())
    var fail = false
    var hex = 0L
    for (i in value.indices) {
        val curV = getValueOfX(value[i])
        if (curV == -1) {
            fail = true
            break
        } else {
            hex += (curV * 16.0.pow((value.length - i - 1).toDouble())).toLong()
        }
    }

    return if (fail) {
        ""
    } else {
        "&#$hex"
    }
}

private fun getValueOfX(c: Char): Int {
    val codes =
        charArrayOf('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f')
    var v = -1
    for (i in codes.indices) {
        if (codes[i] == c) {
            v = i
            break
        }
    }
    return v
}