package com.tuya.appsdk.sample.viettelhome.login

import android.os.Bundle
import android.text.Editable
import android.text.TextWatcher
import android.text.method.PasswordTransformationMethod
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import androidx.core.widget.addTextChangedListener
import androidx.navigation.fragment.findNavController
import com.thingclips.smart.android.common.utils.ValidatorUtil
import com.thingclips.smart.android.user.api.ILoginCallback
import com.thingclips.smart.android.user.bean.User
import com.thingclips.smart.home.sdk.ThingHomeSdk
import com.tuya.appsdk.sample.R
import com.tuya.appsdk.sample.databinding.FragmentLoginBinding


class  LoginFragment : Fragment() {

    private  lateinit var  binding : FragmentLoginBinding

    private  var haveUsername = 0;
    private var havePassword = 0;
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {

        binding = FragmentLoginBinding.inflate(layoutInflater)
        initView()
        enterPhoneNumber()
        enterPassword()


        return binding.root
    }
    private fun initView(){
        binding.tvErrorPhoneNumber.visibility = View.GONE
        binding.tvNullPassword.visibility = View.GONE
    }

    private fun enterPhoneNumber() {
        binding.etPhoneNumber.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(charSequence: CharSequence, i: Int, i1: Int, i2: Int) {
                binding.imgCloseAllNumber.visibility = View.VISIBLE
            }

            override fun onTextChanged(charSequence: CharSequence, i: Int, i1: Int, i2: Int) {
                binding.imgCloseAllNumber.visibility = View.VISIBLE
            }

            override fun afterTextChanged(editable: Editable) {
                if (editable.isNotEmpty()) {
                    binding.imgCloseAllNumber.visibility = View.VISIBLE
                } else {
                    binding.imgCloseAllNumber.visibility = View.INVISIBLE
                }
            }
        })

        binding.imgCloseAllNumber.setOnClickListener {
            // Xóa nội dung của EditText
            binding.etPhoneNumber.setText("")

            // Ẩn ImageView
            binding.imgCloseAllNumber.visibility = View.INVISIBLE
        }
    }

    private fun enterPassword(){
        binding.etPassword.addTextChangedListener(object :TextWatcher{
            override fun beforeTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {
                binding.imgCloseAllPassword.visibility = View.VISIBLE
            }

            override fun onTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {
                binding.imgCloseAllPassword.visibility = View.VISIBLE
            }

            override fun afterTextChanged(editable: Editable?) {
                if(editable?.isNotEmpty() == true){
                    binding.imgCloseAllPassword.visibility = View.VISIBLE
                } else{
                    binding.imgCloseAllPassword.visibility = View.INVISIBLE
                }
            }
        })

        binding.imgCloseAllPassword.setOnClickListener {
            binding.etPassword.setText("")
            binding.imgCloseAllPassword.visibility = View.INVISIBLE
        }

        binding.etPassword.transformationMethod = PasswordTransformationMethod.getInstance()
        binding.imgEyeClose.setOnClickListener {
            togglePasswordVisibility()
        }

        binding.btnLogin.setOnClickListener {
            Log.d("click", "enterPassword: have click")
            if(!binding.etPhoneNumber.text.toString().contains('@')){
                binding.tvErrorPhoneNumber.visibility = View.VISIBLE
                binding.linearEnterPhoneNumber.setBackgroundResource(R.drawable.bg_background_radius_100_error)
            } else {
                binding.tvErrorPhoneNumber.visibility = View.GONE
            }
            if (binding.etPassword.text.toString().isEmpty()) {
                binding.tvNullPassword.text = "Vui lòng nhập mật khẩu"
                binding.tvNullPassword.visibility = View.VISIBLE
                binding.linearEnterPassword.setBackgroundResource(R.drawable.bg_background_radius_100_error)
            } else {
                val countrycode = "84"
                val strAccount = binding.etPhoneNumber.text.toString()
                val password = binding.etPassword.text.toString()
                val callback  = object : ILoginCallback{
                    override fun onSuccess(user: User?) {
                        Toast.makeText(
                            context,
                            "Login success",
                            Toast.LENGTH_LONG
                        ).show()

                        findNavController().navigate(R.id.action_loginFragment_to_homeManageFragment)
                    }

                    override fun onError(code: String?, error: String?) {
                        binding.tvNullPassword.setText("Tài khoản hoặc mật khẩu không chính xác.")
                        binding.tvNullPassword.visibility = View.VISIBLE
                        binding.linearEnterPassword.setBackgroundResource(R.drawable.bg_background_radius_100_error)
                        Toast.makeText(
                            context,
                            "login error->$error",
                            Toast.LENGTH_LONG
                        ).show()
                    }
                }
                if(ValidatorUtil.isEmail(strAccount)){
                    ThingHomeSdk.getUserInstance()
                        .loginWithEmail(countrycode,strAccount,password,callback)
                } else{
                    ThingHomeSdk.getUserInstance()
                        .loginWithPhonePassword(countrycode,strAccount,password,callback)
                }
            }
        }

    }

    private fun togglePasswordVisibility(){
        if(isPasswordVisible()){
            binding.etPassword.transformationMethod = PasswordTransformationMethod.getInstance()
        } else{
            binding.etPassword.transformationMethod = null
        }
        binding.etPassword.setSelection(binding.etPassword.text.length)
    }

    private fun isPasswordVisible() : Boolean{
        return binding.etPassword.transformationMethod == null
    }

}