package com.tuya.appsdk.sample.viettelhome.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.tuya.appsdk.sample.R
import com.tuya.appsdk.sample.viettelhome.device.Device

class DeviceAdapter(private val devices : List<Device>) : RecyclerView.Adapter<DeviceAdapter.ViewHolder>() {

    class ViewHolder(itemView : View) : RecyclerView.ViewHolder(itemView){
        val imgDevice : ImageView = itemView.findViewById(R.id.img_device)
        val tvNameDevice : TextView = itemView.findViewById(R.id.tv_name_device)
        val tvPositionDevice : TextView = itemView.findViewById(R.id.tv_position)
        val imgStatusDevice : ImageView = itemView.findViewById(R.id.img_status_device)
        val tvStatusDevice : TextView = itemView.findViewById(R.id.tv_status_device)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val view = LayoutInflater.from(parent.context).inflate(R.layout.item_device,parent,false)
        return ViewHolder(view)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.imgDevice.setBackgroundResource(devices[position].getImg())
        holder.tvNameDevice.text = devices[position].getName()
        holder.tvPositionDevice.text = devices[position].getPosition()
        if(devices[position].getStatus() == 1){
            holder.imgStatusDevice.setBackgroundResource(R.drawable.ic_online_status)
            holder.tvStatusDevice.text = "Trực tuyến"
        } else {
            holder.imgStatusDevice.setBackgroundResource(R.drawable.ic_offline_status)
            holder.tvStatusDevice.text = "Mất kết nối"
        }
    }

    override fun getItemCount(): Int {
        return devices.size
    }


}