package com.tuya.appsdk.sample.viettelhome.home

import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.recyclerview.widget.LinearLayoutManager
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.tuya.appsdk.sample.R
import com.tuya.appsdk.sample.databinding.FragmentListHomeBinding
import com.tuya.appsdk.sample.databinding.FragmentRoomBinding
import com.tuya.appsdk.sample.viettelhome.adapter.SmartHomeAdapter

class ListHomeFragment(private  var onSelectedHome : SelectedHomeListener)  : BottomSheetDialogFragment() {

    private lateinit var binding: FragmentListHomeBinding

    private  val demoListHome = listOf(
        Home("Smart Home"),
        Home("Smart Home 1"),
        Home("Smart Home 2")
    )

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = FragmentListHomeBinding.inflate(inflater)
        return binding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        val bottomSheet = dialog?.findViewById<View>(com.google.android.material.R.id.design_bottom_sheet)
        bottomSheet?.background = ColorDrawable(Color.TRANSPARENT)
        binding.recyclerListHome.apply {
            layoutManager = LinearLayoutManager(context)
            adapter = SmartHomeAdapter(demoListHome)
        }
    }


}