package com.tuya.appsdk.sample.viettelhome.home

import android.graphics.Color
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.fragment.app.Fragment
import androidx.viewpager2.widget.ViewPager2
import com.google.android.material.tabs.TabLayout
import com.google.android.material.tabs.TabLayoutMediator
import com.tuya.appsdk.sample.R
import com.tuya.appsdk.sample.databinding.FragmentDeviceBinding
import com.tuya.appsdk.sample.viettelhome.adapter.RoomPagerAdapter
import com.tuya.appsdk.sample.viettelhome.room.RoomFragment

class DeviceFragment : Fragment(), SelectedHomeListener {


    private lateinit var bindind : FragmentDeviceBinding

    private val titles = arrayOf("Tất cả các thiết bị", "Phòng khách", "Phòng ngủ", "Phòng bếp","Phòng vệ sinh")

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        bindind = FragmentDeviceBinding.inflate(layoutInflater)
        setupTablayout()
        setupDiaglogHome()
        return bindind.root
    }


    fun setupDiaglogHome(){
        bindind.linearBtnSmartHome.setOnClickListener {
            val bottomSheetDialogFilter = ListHomeFragment(this)
            bottomSheetDialogFilter.show(childFragmentManager, "bottom_sheet_dialog_home")
        }
    }

    fun setupTablayout(){
        val viewPager : ViewPager2 = bindind.viewpager2
        val tabLayout : TabLayout = bindind.tbLayout
        val roomAdapter = RoomPagerAdapter(childFragmentManager,lifecycle)
        roomAdapter.addFragment(RoomFragment.newInstance())
        roomAdapter.addFragment(RoomFragment.newInstance())
        roomAdapter.addFragment(RoomFragment.newInstance())
        roomAdapter.addFragment(RoomFragment.newInstance())
        roomAdapter.addFragment(RoomFragment.newInstance())
        roomAdapter.notifyDataSetChanged()

        viewPager.adapter = roomAdapter
        viewPager.isSaveEnabled = false
        TabLayoutMediator(tabLayout,viewPager){ tab,position ->
            tab.customView = LayoutInflater.from(requireContext()).inflate(R.layout.tab_custom,null)
            tab.customView?.findViewById<TextView>(R.id.tab_title)?.text = titles[position]
        }.attach()

        tabLayout.addOnTabSelectedListener(object :TabLayout.OnTabSelectedListener{
            override fun onTabSelected(tab: TabLayout.Tab?) {
                tab?.customView?.findViewById<TextView>(R.id.tab_title)?.setTextColor(Color.parseColor("#EC0D3A"))
            }

            override fun onTabUnselected(tab: TabLayout.Tab?) {
                tab?.customView?.findViewById<TextView>(R.id.tab_title)?.setTextColor(Color.parseColor("#4E4E4E"))
            }

            override fun onTabReselected(tab: TabLayout.Tab?) {
                tab?.customView?.findViewById<TextView>(R.id.tab_title)?.setTextColor(Color.parseColor("#EC0D3A"))
            }

        })
    }

    override fun onSelectedHome(name: String) {

    }


}