package com.tuya.appsdk.sample.viettelhome.home

import android.content.res.ColorStateList
import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import com.google.android.material.bottomnavigation.BottomNavigationView
import com.tuya.appsdk.sample.R
import com.tuya.appsdk.sample.databinding.FragmentHomeManageBinding
import com.tuya.appsdk.sample.databinding.FragmentLoginBinding

class HomeManageFragment : Fragment() {

    private lateinit var binding: FragmentHomeManageBinding
    private lateinit var homePageFragment: HomePageFragment
    private lateinit var deviceFragment: DeviceFragment
    private lateinit var scenceFragment: ScenceFragment
    private lateinit var shoppingFragment: ShoppingFragment
    private lateinit var personalFragment: PersonalFragment
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = FragmentHomeManageBinding.inflate(layoutInflater)
        setupNavigation()

        return binding.root
    }

    fun setupNavigation(){
        val bottomNavigationView = binding.bottomNavigation
        homePageFragment = HomePageFragment()
        deviceFragment = DeviceFragment()
        scenceFragment = ScenceFragment()
        shoppingFragment = ShoppingFragment()
        personalFragment = PersonalFragment()


        requireActivity().supportFragmentManager.beginTransaction().replace(R.id.container,homePageFragment).commit()

        bottomNavigationView.setOnItemSelectedListener {
            var selectedFragment: Fragment? = null
            when (it.itemId) {
                R.id.nav_home -> selectedFragment = homePageFragment
                R.id.nav_device -> selectedFragment = deviceFragment
                R.id.nav_scence -> selectedFragment = scenceFragment
                R.id.nav_shopping -> selectedFragment = shoppingFragment
                R.id.nav_personal -> selectedFragment = personalFragment
            }
            requireActivity().supportFragmentManager.beginTransaction().replace(R.id.container, selectedFragment!!).commit()
            true
        }
    }

}