#!bin/bash

# This file used for set up nfs server on Ubuntu 22.04
# Subnet “10.0.2.15/24” (Client) to access the NFS server


# Update system packages
sudo apt update

# Install NFS server
sudo apt install nfs-kernel-server

# Make shared NFS directory
sudo mkdir -p /mnt/nfs_share

# Set directory permissions
sudo chown -R nobody:nogroup /mnt/nfs_share/

# Set file permissions
sudo chmod 777 /mnt/nfs_share/

# Grant NFS access
sudo echo "/mnt/nfs_share 10.0.2.15/24(rw,sync,no_subtree_check)" > /etc/exports

# Exporting NFS directory
sudo exportfs -a

# Restart NFS server
sudo systemctl restart nfs-kernel-server

# Grant Firewall access
sudo ufw allow from 10.0.2.15/24 to any port nfs

# Enable Firewall
sudo ufw enable

# Check Firewall status
sudo ufw status