#!/bin/bash

sudo apt update

# Install nginx
sudo apt install -y nginx

# Install mysql-server
sudo apt install -y mysql-server

# Create a database that WordPress can use
sudo mysqladmin create wordpress
sudo mysql
mysql> CREATE USER wordpress@localhost identified by 'wordpress123';
mysql> GRANT ALL on wordpress.* to wordpress@localhost;
mysql> exit
sudo mysql
mysql> SET PASSWORD for wordpress@localhost = 'wordpress123';
mysql> exit

# Install PHP
sudo apt install -y php-fpm

#Install the required PHP modules.
sudo apt install -y php-mysql php-curl php-mbstring php-imagick php-xml php-zip

#Configure NGINX
sudo bash -c 'cat > /etc/nginx/sites-available/default <<EOF
server {
    listen 80 default_server;
    listen [::]:80 default_server;

    root /var/www/html;

    index index.php index.html index.htm index.nginx-debian.html;

    server_name _;

    location / {
        try_files $uri $uri/ /index.php$is_args$args;
    }
    location ~ \.php$ {
        include snippets/fastcgi-php.conf;
        fastcgi_pass unix:/var/run/php/php7.4-fpm.sock;
    }
}
EOF'
sudo systemctl reload nginx

#Download WordPress
cd
curl -O https://wordpress.org/wordpress-5.6.tar.gz

#Extract WordPress and Move It Into the DocumentRoot
tar xvf wordpress-5.6.tar.gz
sudo mv wordpress/* /var/www/html

#Assign File Permissions for WordPress
sudo chown -R www-data:www-data /var/www/html


