# Run the kubectl command to create a namespace:
kubectl create namespace ingress-nginx

# Run the command to add the helm repository for the nginx Controller:
helm repo add ingress-nginx https://kubernetes.github.io/ingress-nginx

# Run the command to update the helm repository data:
helm repo update

# Run the command to install the Controller:
helm install ingress-nginx ingress-nginx/ingress-nginx  \
--namespace ingress \
--set controller.ingressClassResource.name=nginx

# Use this command to get the IP address:
watch kubectl -n ingress get svc

# Create self-signed certificate
openssl req -x509 -nodes -days 365 -newkey rsa:2048 -keyout tls.key -out tls.crt -subj "/CN=172.16.0.16.nip.io"

# Create Kubernetes Secret from certificate
kubectl create secret tls 172.16.0.16.nip.io --cert=tls.crt --key=tls.key
